/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.Set;

public class IllegalTokenTextCheck
extends AbstractFormatCheck {
    private String mMessage = "";

    public IllegalTokenTextCheck() {
        super("$^");
    }

    @Override
    public void beginTree(DetailAST aRootAST) {
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[0];
    }

    @Override
    public int[] getAcceptableTokens() {
        Set<String> tokenNames = this.getTokenNames();
        int[] result = new int[tokenNames.size()];
        int i = 0;
        for (String name : tokenNames) {
            result[i] = TokenTypes.getTokenId(name);
            ++i;
        }
        return result;
    }

    @Override
    public void visitToken(DetailAST aAST) {
        String text = aAST.getText();
        if (this.getRegexp().matcher(text).find()) {
            String message = this.getMessage();
            if ("".equals(message)) {
                message = "illegal.token.text";
            }
            this.log(aAST.getLineNo(), aAST.getColumnNo(), message, this.getFormat());
        }
    }

    public void setMessage(String aMessage) {
        this.mMessage = null == aMessage ? "" : aMessage;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setIgnoreCase(boolean aCaseInsensitive) {
        if (aCaseInsensitive) {
            this.setCompileFlags(2);
        }
    }
}

