/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.io.Closeables;
import com.google.common.io.Flushables;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;

final class PropertyCacheFile {
    private static final String CONFIG_HASH_KEY = "configuration*?";
    private final Properties details = new Properties();
    private final Configuration config;
    private final String fileName;

    PropertyCacheFile(Configuration config, String fileName) {
        if (config == null) {
            throw new IllegalArgumentException("config can not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName can not be null");
        }
        this.config = config;
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        block4: {
            String currentConfigHash;
            block3: {
                FileInputStream inStream;
                block2: {
                    currentConfigHash = PropertyCacheFile.getConfigHashCode(this.config);
                    if (!new File(this.fileName).exists()) break block3;
                    inStream = null;
                    try {
                        inStream = new FileInputStream(this.fileName);
                        this.details.load(inStream);
                        String cachedConfigHash = this.details.getProperty(CONFIG_HASH_KEY);
                        if (currentConfigHash.equals(cachedConfigHash)) break block2;
                        this.details.clear();
                        this.details.setProperty(CONFIG_HASH_KEY, currentConfigHash);
                    }
                    catch (Throwable throwable) {
                        Closeables.closeQuietly(inStream);
                        throw throwable;
                    }
                }
                Closeables.closeQuietly((InputStream)inStream);
                break block4;
            }
            this.details.setProperty(CONFIG_HASH_KEY, currentConfigHash);
        }
    }

    public void persist() throws IOException {
        try {
            Path directory = Paths.get(this.fileName, new String[0]).getParent();
            if (directory != null) {
                Files.createDirectories(directory, new FileAttribute[0]);
            }
        }
        catch (AccessDeniedException | InvalidPathException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.fileName);
            this.details.store(out, null);
        }
        catch (Throwable throwable) {
            PropertyCacheFile.flushAndCloseOutStream(out);
            throw throwable;
        }
        PropertyCacheFile.flushAndCloseOutStream(out);
    }

    public void clear() {
        this.details.clear();
    }

    private static void flushAndCloseOutStream(OutputStream stream) throws IOException {
        if (stream != null) {
            Flushables.flush((Flushable)stream, (boolean)false);
        }
        Closeables.close((Closeable)stream, (boolean)false);
    }

    public boolean isInCache(String uncheckedFileName, long timestamp) {
        String lastChecked = this.details.getProperty(uncheckedFileName);
        return lastChecked != null && lastChecked.equals(Long.toString(timestamp));
    }

    public void put(String checkedFileName, long timestamp) {
        this.details.setProperty(checkedFileName, Long.toString(timestamp));
    }

    private static String getConfigHashCode(Serializable object) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(outputStream);
                oos.writeObject(object);
            }
            catch (Throwable throwable) {
                PropertyCacheFile.flushAndCloseOutStream(oos);
                throw throwable;
            }
            PropertyCacheFile.flushAndCloseOutStream(oos);
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(outputStream.toByteArray());
            return DatatypeConverter.printHexBinary((byte[])digest.digest());
        }
        catch (IOException | NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Unable to calculate hashcode.", ex);
        }
    }
}

