/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class RequireThisCheck
extends AbstractCheck {
    public static final String MSG_METHOD = "require.this.method";
    public static final String MSG_VARIABLE = "require.this.variable";
    private static final ImmutableSet<Integer> DECLARATION_TOKENS = ImmutableSet.of((Object)10, (Object)8, (Object)9, (Object)14, (Object)154, (Object)15, (Object[])new Integer[]{21, 164});
    private static final ImmutableSet<Integer> ASSIGN_TOKENS = ImmutableSet.of((Object)80, (Object)98, (Object)100, (Object)101, (Object)102, (Object)103, (Object[])new Integer[]{104, 105, 106, 107});
    private static final ImmutableSet<Integer> COMPOUND_ASSIGN_TOKENS = ImmutableSet.of((Object)98, (Object)100, (Object)101, (Object)102, (Object)103, (Object)104, (Object[])new Integer[]{105, 106, 107});
    private Map<DetailAST, AbstractFrame> frames;
    private AbstractFrame current;
    private boolean checkFields = true;
    private boolean checkMethods = true;
    private boolean validateOnlyOverlapping = true;

    public void setCheckFields(boolean checkFields) {
        this.checkFields = checkFields;
    }

    public void setCheckMethods(boolean checkMethods) {
        this.checkMethods = checkMethods;
    }

    public void setValidateOnlyOverlapping(boolean validateOnlyOverlapping) {
        this.validateOnlyOverlapping = validateOnlyOverlapping;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 8, 9, 7, 58};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.frames = Maps.newHashMap();
        this.current = null;
        LinkedList frameStack = Lists.newLinkedList();
        DetailAST curNode = rootAST;
        while (curNode != null) {
            RequireThisCheck.collectDeclarations(frameStack, curNode);
            DetailAST toVisit = curNode.getFirstChild();
            while (curNode != null && toVisit == null) {
                this.endCollectingDeclarations(frameStack, curNode);
                toVisit = curNode.getNextSibling();
                if (toVisit != null) continue;
                curNode = curNode.getParent();
            }
            curNode = toVisit;
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 58: {
                this.processIdent(ast);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.current = this.frames.get((Object)ast);
                break;
            }
        }
    }

    private void processIdent(DetailAST ast) {
        int parentType = ast.getParent().getType();
        switch (parentType) {
            case 159: 
            case 160: 
            case 161: {
                break;
            }
            case 27: {
                AbstractFrame frame;
                if (!this.checkMethods || (frame = this.getMethodWithoutThis(ast)) == null) break;
                this.logViolation(MSG_METHOD, ast, frame);
                break;
            }
            default: {
                AbstractFrame frame;
                if (!this.checkFields || (frame = this.getFieldWithoutThis(ast, parentType)) == null) break;
                this.logViolation(MSG_VARIABLE, ast, frame);
            }
        }
    }

    private void logViolation(String msgKey, DetailAST ast, AbstractFrame frame) {
        if (frame.getFrameName().equals(this.getNearestClassFrameName())) {
            this.log(ast, msgKey, ast.getText(), "");
        } else {
            this.log(ast, msgKey, ast.getText(), frame.getFrameName() + '.');
        }
    }

    private AbstractFrame getFieldWithoutThis(DetailAST ast, int parentType) {
        boolean importOrPackage = ScopeUtils.getSurroundingScope(ast) == null;
        boolean methodNameInMethodCall = parentType == 59 && ast.getPreviousSibling() != null;
        boolean typeName = parentType == 13 || parentType == 136;
        AbstractFrame frame = null;
        if (!(importOrPackage || methodNameInMethodCall || typeName || RequireThisCheck.isDeclarationToken(parentType))) {
            frame = this.getClassFrameWhereViolationIsFound(ast);
        }
        return frame;
    }

    private static void collectDeclarations(Deque<AbstractFrame> frameStack, DetailAST ast) {
        AbstractFrame frame = frameStack.peek();
        switch (ast.getType()) {
            case 10: {
                RequireThisCheck.collectVariableDeclarations(ast, frame);
                break;
            }
            case 21: {
                DetailAST parameterIdent = ast.findFirstToken(58);
                frame.addIdent(parameterIdent);
                break;
            }
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                DetailAST classFrameNameIdent = ast.findFirstToken(58);
                frameStack.addFirst(new ClassFrame(frame, classFrameNameIdent));
                break;
            }
            case 7: {
                frameStack.addFirst(new BlockFrame(frame, ast));
                break;
            }
            case 9: {
                DetailAST methodFrameNameIdent = ast.findFirstToken(58);
                if (frame.getType() == FrameType.CLASS_FRAME) {
                    DetailAST mods = ast.findFirstToken(5);
                    if (mods.branchContains(64)) {
                        ((ClassFrame)frame).addStaticMethod(methodFrameNameIdent);
                    } else {
                        ((ClassFrame)frame).addInstanceMethod(methodFrameNameIdent);
                    }
                }
                frameStack.addFirst(new MethodFrame(frame, methodFrameNameIdent));
                break;
            }
            case 8: {
                DetailAST ctorFrameNameIdent = ast.findFirstToken(58);
                frameStack.addFirst(new ConstructorFrame(frame, ctorFrameNameIdent));
                break;
            }
        }
    }

    private static void collectVariableDeclarations(DetailAST ast, AbstractFrame frame) {
        DetailAST ident = ast.findFirstToken(58);
        if (frame.getType() == FrameType.CLASS_FRAME) {
            DetailAST mods = ast.findFirstToken(5);
            if (ScopeUtils.isInInterfaceBlock(ast) || mods.branchContains(64)) {
                ((ClassFrame)frame).addStaticMember(ident);
            } else {
                ((ClassFrame)frame).addInstanceMember(ident);
            }
        } else {
            frame.addIdent(ident);
        }
    }

    private void endCollectingDeclarations(Queue<AbstractFrame> frameStack, DetailAST ast) {
        switch (ast.getType()) {
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 154: 
            case 157: {
                this.frames.put(ast, frameStack.poll());
                break;
            }
        }
    }

    private AbstractFrame getClassFrameWhereViolationIsFound(DetailAST ast) {
        AbstractFrame frameWhereViolationIsFound = null;
        AbstractFrame variableDeclarationFrame = this.findFrame(ast, false);
        if (variableDeclarationFrame != null) {
            FrameType variableDeclarationFrameType = variableDeclarationFrame.getType();
            DetailAST prevSibling = ast.getPreviousSibling();
            if (variableDeclarationFrameType == FrameType.CLASS_FRAME && !this.validateOnlyOverlapping && prevSibling == null && !ScopeUtils.isInInterfaceBlock(ast) && this.canBeReferencedFromStaticContext(ast)) {
                frameWhereViolationIsFound = variableDeclarationFrame;
            } else if (variableDeclarationFrameType == FrameType.METHOD_FRAME) {
                if (this.isOverlappingByArgument(ast)) {
                    if (!RequireThisCheck.isUserDefinedArrangementOfThis(variableDeclarationFrame, ast) && !RequireThisCheck.isReturnedVariable(variableDeclarationFrame, ast) && this.canBeReferencedFromStaticContext(ast) && this.canAssignValueToClassField(ast)) {
                        frameWhereViolationIsFound = this.findFrame(ast, true);
                    }
                } else if (!this.validateOnlyOverlapping && prevSibling == null && RequireThisCheck.isAssignToken(ast.getParent().getType()) && !RequireThisCheck.isUserDefinedArrangementOfThis(variableDeclarationFrame, ast) && this.canBeReferencedFromStaticContext(ast) && this.canAssignValueToClassField(ast)) {
                    frameWhereViolationIsFound = this.findFrame(ast, true);
                }
            } else if (variableDeclarationFrameType == FrameType.CTOR_FRAME && this.isOverlappingByArgument(ast) && !RequireThisCheck.isUserDefinedArrangementOfThis(variableDeclarationFrame, ast)) {
                frameWhereViolationIsFound = this.findFrame(ast, true);
            } else if (variableDeclarationFrameType == FrameType.BLOCK_FRAME) {
                if (this.isOverlappingByLocalVariable(ast)) {
                    if (this.canAssignValueToClassField(ast) && !RequireThisCheck.isUserDefinedArrangementOfThis(variableDeclarationFrame, ast) && !RequireThisCheck.isReturnedVariable(variableDeclarationFrame, ast) && this.canBeReferencedFromStaticContext(ast)) {
                        frameWhereViolationIsFound = this.findFrame(ast, true);
                    }
                } else if (!this.validateOnlyOverlapping && prevSibling == null && RequireThisCheck.isAssignToken(ast.getParent().getType()) && !RequireThisCheck.isUserDefinedArrangementOfThis(variableDeclarationFrame, ast) && this.canBeReferencedFromStaticContext(ast)) {
                    frameWhereViolationIsFound = this.findFrame(ast, true);
                }
            }
        }
        return frameWhereViolationIsFound;
    }

    private static boolean isUserDefinedArrangementOfThis(AbstractFrame currentFrame, DetailAST ident) {
        DetailAST blockFrameNameIdent = currentFrame.getFrameNameIdent();
        DetailAST definitionToken = blockFrameNameIdent.getParent();
        DetailAST blockStartToken = definitionToken.findFirstToken(7);
        DetailAST blockEndToken = RequireThisCheck.getBlockEndToken(blockFrameNameIdent, blockStartToken);
        Set<DetailAST> variableUsagesInsideBlock = RequireThisCheck.getAllTokensWhichAreEqualToCurrent(definitionToken, ident, blockEndToken.getLineNo());
        boolean userDefinedArrangementOfThis = false;
        for (DetailAST variableUsage : variableUsagesInsideBlock) {
            DetailAST prevSibling = variableUsage.getPreviousSibling();
            if (prevSibling == null || prevSibling.getType() != 78) continue;
            userDefinedArrangementOfThis = true;
        }
        return userDefinedArrangementOfThis;
    }

    private static DetailAST getBlockEndToken(DetailAST blockNameIdent, DetailAST blockStartToken) {
        Set<DetailAST> rcurlyTokens = RequireThisCheck.getAllTokensOfType(blockNameIdent, 73);
        DetailAST blockEndToken = null;
        for (DetailAST currentRcurly : rcurlyTokens) {
            DetailAST parent = currentRcurly.getParent();
            if (blockStartToken.getLineNo() != parent.getLineNo()) continue;
            blockEndToken = currentRcurly;
        }
        return blockEndToken;
    }

    private static boolean isReturnedVariable(AbstractFrame currentFrame, DetailAST ident) {
        DetailAST returnToken;
        DetailAST blockFrameNameIdent = currentFrame.getFrameNameIdent();
        DetailAST definitionToken = blockFrameNameIdent.getParent();
        DetailAST blockStartToken = definitionToken.findFirstToken(7);
        DetailAST blockEndToken = RequireThisCheck.getBlockEndToken(blockFrameNameIdent, blockStartToken);
        Set<DetailAST> returnsInsideBlock = RequireThisCheck.getAllTokensOfType(definitionToken, 88, blockEndToken.getLineNo());
        boolean returnedVariable = false;
        Iterator<DetailAST> iterator = returnsInsideBlock.iterator();
        while (iterator.hasNext() && !(returnedVariable = (returnToken = iterator.next()).findAll((AST)ident).hasMoreNodes())) {
        }
        return returnedVariable;
    }

    private boolean canBeReferencedFromStaticContext(DetailAST ident) {
        AbstractFrame variableDeclarationFrame = this.findFrame(ident, false);
        boolean staticInitializationBlock = false;
        while (variableDeclarationFrame.getType() == FrameType.BLOCK_FRAME) {
            DetailAST blockFrameNameIdent = variableDeclarationFrame.getFrameNameIdent();
            DetailAST definitionToken = blockFrameNameIdent.getParent();
            if (definitionToken.getType() == 12) {
                staticInitializationBlock = true;
                break;
            }
            variableDeclarationFrame = variableDeclarationFrame.getParent();
        }
        boolean staticContext = false;
        if (staticInitializationBlock) {
            staticContext = true;
        } else if (variableDeclarationFrame.getType() == FrameType.CLASS_FRAME) {
            DetailAST codeBlockDefinition = RequireThisCheck.getCodeBlockDefinitionToken(ident);
            if (codeBlockDefinition != null) {
                DetailAST modifiers = codeBlockDefinition.getFirstChild();
                staticContext = codeBlockDefinition.getType() == 12 || modifiers.branchContains(64);
            }
        } else {
            DetailAST frameNameIdent = variableDeclarationFrame.getFrameNameIdent();
            DetailAST definitionToken = frameNameIdent.getParent();
            staticContext = definitionToken.branchContains(64);
        }
        return !staticContext;
    }

    private static DetailAST getCodeBlockDefinitionToken(DetailAST ident) {
        DetailAST parent;
        for (parent = ident.getParent(); parent != null && parent.getType() != 9 && parent.getType() != 8 && parent.getType() != 12; parent = parent.getParent()) {
        }
        return parent;
    }

    private boolean canAssignValueToClassField(DetailAST ast) {
        AbstractFrame fieldUsageFrame = this.findFrame(ast, false);
        boolean fieldUsageInConstructor = RequireThisCheck.isInsideConstructorFrame(fieldUsageFrame);
        AbstractFrame declarationFrame = this.findFrame(ast, true);
        boolean finalField = false;
        if (declarationFrame != null) {
            finalField = ((ClassFrame)declarationFrame).hasFinalField(ast);
        }
        return fieldUsageInConstructor || !finalField;
    }

    private static boolean isInsideConstructorFrame(AbstractFrame frame) {
        boolean assignmentInConstructor = false;
        AbstractFrame fieldUsageFrame = frame;
        if (fieldUsageFrame.getType() == FrameType.BLOCK_FRAME) {
            while (fieldUsageFrame.getType() == FrameType.BLOCK_FRAME) {
                fieldUsageFrame = fieldUsageFrame.getParent();
            }
            if (fieldUsageFrame.getType() == FrameType.CTOR_FRAME) {
                assignmentInConstructor = true;
            }
        }
        return assignmentInConstructor;
    }

    private boolean isOverlappingByArgument(DetailAST ast) {
        ClassFrame classFrame;
        boolean overlapping = false;
        DetailAST parent = ast.getParent();
        DetailAST sibling = ast.getNextSibling();
        if (sibling != null && RequireThisCheck.isAssignToken(parent.getType()) && (classFrame = (ClassFrame)this.findFrame(ast, true)) != null) {
            Set<DetailAST> exprIdents = RequireThisCheck.getAllTokensOfType(sibling, 58);
            overlapping = RequireThisCheck.isCompoundAssignToken(parent.getType()) ? true : classFrame.containsFieldOrVariableDef(exprIdents, ast);
        }
        return overlapping;
    }

    private boolean isOverlappingByLocalVariable(DetailAST ast) {
        ClassFrame classFrame;
        boolean overlapping = false;
        DetailAST parent = ast.getParent();
        DetailAST sibling = ast.getNextSibling();
        if (sibling != null && RequireThisCheck.isAssignToken(parent.getType()) && (classFrame = (ClassFrame)this.findFrame(ast, true)) != null) {
            Set<DetailAST> exprIdents = RequireThisCheck.getAllTokensOfType(sibling, 58);
            if (classFrame.hasInstanceMember(ast)) {
                overlapping = classFrame.containsFieldOrVariableDef(exprIdents, ast);
            }
        }
        return overlapping;
    }

    private static Set<DetailAST> getAllTokensOfType(DetailAST ast, int tokenType) {
        DetailAST vertex = ast;
        HashSet result = Sets.newHashSet();
        ArrayDeque stack = Queues.newArrayDeque();
        while (vertex != null || !stack.isEmpty()) {
            if (!stack.isEmpty()) {
                vertex = (DetailAST)((Object)stack.pop());
            }
            while (vertex != null) {
                if (vertex.getType() == tokenType) {
                    result.add(vertex);
                }
                if (vertex.getNextSibling() != null) {
                    stack.push(vertex.getNextSibling());
                }
                vertex = vertex.getFirstChild();
            }
        }
        return result;
    }

    private static Set<DetailAST> getAllTokensOfType(DetailAST ast, int tokenType, int endLineNumber) {
        DetailAST vertex = ast;
        HashSet result = Sets.newHashSet();
        ArrayDeque stack = Queues.newArrayDeque();
        while (vertex != null || !stack.isEmpty()) {
            if (!stack.isEmpty()) {
                vertex = (DetailAST)((Object)stack.pop());
            }
            while (vertex != null) {
                if (tokenType == vertex.getType() && vertex.getLineNo() <= endLineNumber) {
                    result.add(vertex);
                }
                if (vertex.getNextSibling() != null) {
                    stack.push(vertex.getNextSibling());
                }
                vertex = vertex.getFirstChild();
            }
        }
        return result;
    }

    private static Set<DetailAST> getAllTokensWhichAreEqualToCurrent(DetailAST ast, DetailAST token, int endLineNumber) {
        DetailAST vertex = ast;
        HashSet result = Sets.newHashSet();
        ArrayDeque stack = Queues.newArrayDeque();
        while (vertex != null || !stack.isEmpty()) {
            if (!stack.isEmpty()) {
                vertex = (DetailAST)((Object)stack.pop());
            }
            while (vertex != null) {
                if (token.equals((AST)vertex) && vertex.getLineNo() <= endLineNumber) {
                    result.add(vertex);
                }
                if (vertex.getNextSibling() != null) {
                    stack.push(vertex.getNextSibling());
                }
                vertex = vertex.getFirstChild();
            }
        }
        return result;
    }

    private AbstractFrame getMethodWithoutThis(DetailAST ast) {
        AbstractFrame result = null;
        AbstractFrame frame = this.findFrame(ast, true);
        if (frame != null && !this.validateOnlyOverlapping && ((ClassFrame)frame).hasInstanceMethod(ast) && !((ClassFrame)frame).hasStaticMethod(ast)) {
            result = frame;
        }
        return result;
    }

    private AbstractFrame findFrame(DetailAST name, boolean lookForMethod) {
        AbstractFrame result = this.current == null ? null : this.current.getIfContains(name, lookForMethod);
        return result;
    }

    private static boolean isDeclarationToken(int parentType) {
        return DECLARATION_TOKENS.contains((Object)parentType);
    }

    private static boolean isAssignToken(int tokenType) {
        return ASSIGN_TOKENS.contains((Object)tokenType);
    }

    private static boolean isCompoundAssignToken(int tokenType) {
        return COMPOUND_ASSIGN_TOKENS.contains((Object)tokenType);
    }

    private String getNearestClassFrameName() {
        AbstractFrame frame = this.current;
        while (frame.getType() != FrameType.CLASS_FRAME) {
            frame = frame.getParent();
        }
        return frame.getFrameName();
    }

    private static class BlockFrame
    extends AbstractFrame {
        protected BlockFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        protected FrameType getType() {
            return FrameType.BLOCK_FRAME;
        }
    }

    private static class ClassFrame
    extends AbstractFrame {
        private final Set<DetailAST> instanceMembers = Sets.newHashSet();
        private final Set<DetailAST> instanceMethods = Sets.newHashSet();
        private final Set<DetailAST> staticMembers = Sets.newHashSet();
        private final Set<DetailAST> staticMethods = Sets.newHashSet();

        ClassFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        protected FrameType getType() {
            return FrameType.CLASS_FRAME;
        }

        public void addStaticMember(DetailAST ident) {
            this.staticMembers.add(ident);
        }

        public void addStaticMethod(DetailAST ident) {
            this.staticMethods.add(ident);
        }

        public void addInstanceMember(DetailAST ident) {
            this.instanceMembers.add(ident);
        }

        public void addInstanceMethod(DetailAST ident) {
            this.instanceMethods.add(ident);
        }

        public boolean hasInstanceMember(DetailAST ident) {
            return this.containsFieldOrVariableDef(this.instanceMembers, ident);
        }

        public boolean hasInstanceMethod(DetailAST ident) {
            return this.containsMethodDef(this.instanceMethods, ident);
        }

        public boolean hasStaticMethod(DetailAST ident) {
            return this.containsMethodDef(this.staticMethods, ident);
        }

        public boolean hasFinalField(DetailAST instanceMember) {
            boolean result = false;
            for (DetailAST member : this.instanceMembers) {
                DetailAST mods = member.getParent().findFirstToken(5);
                boolean finalMod = mods.branchContains(39);
                if (!finalMod || !member.equals((AST)instanceMember)) continue;
                result = true;
            }
            return result;
        }

        @Override
        protected boolean containsFieldOrVariable(DetailAST nameToFind) {
            return this.containsFieldOrVariableDef(this.instanceMembers, nameToFind) || this.containsFieldOrVariableDef(this.staticMembers, nameToFind);
        }

        @Override
        protected boolean isProperDefinition(DetailAST ident, DetailAST ast) {
            String nameToFind = ident.getText();
            return nameToFind.equals(ast.getText());
        }

        @Override
        protected AbstractFrame getIfContains(DetailAST nameToFind, boolean lookForMethod) {
            AbstractFrame frame = null;
            if (lookForMethod && this.containsMethod(nameToFind) || this.containsFieldOrVariable(nameToFind)) {
                frame = this;
            } else if (this.getParent() != null) {
                frame = this.getParent().getIfContains(nameToFind, lookForMethod);
            }
            return frame;
        }

        private boolean containsMethod(DetailAST methodToFind) {
            return this.containsMethodDef(this.instanceMethods, methodToFind) || this.containsMethodDef(this.staticMethods, methodToFind);
        }

        private boolean containsMethodDef(Set<DetailAST> set, DetailAST ident) {
            boolean result = false;
            for (DetailAST ast : set) {
                if (!this.isSimilarSignature(ident, ast)) continue;
                result = true;
                break;
            }
            return result;
        }

        private boolean isSimilarSignature(DetailAST ident, DetailAST ast) {
            boolean result = false;
            DetailAST elistToken = ident.getParent().findFirstToken(34);
            if (elistToken != null && ident.getText().equals(ast.getText())) {
                int argsNumber;
                int paramsNumber = ast.getParent().findFirstToken(20).getChildCount();
                result = paramsNumber == (argsNumber = elistToken.getChildCount());
            }
            return result;
        }
    }

    private static class ConstructorFrame
    extends AbstractFrame {
        protected ConstructorFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        protected FrameType getType() {
            return FrameType.CTOR_FRAME;
        }
    }

    private static class MethodFrame
    extends AbstractFrame {
        protected MethodFrame(AbstractFrame parent, DetailAST ident) {
            super(parent, ident);
        }

        @Override
        protected FrameType getType() {
            return FrameType.METHOD_FRAME;
        }
    }

    private static abstract class AbstractFrame {
        private final Set<DetailAST> varIdents;
        private final AbstractFrame parent;
        private final DetailAST frameNameIdent;

        protected AbstractFrame(AbstractFrame parent, DetailAST ident) {
            this.parent = parent;
            this.frameNameIdent = ident;
            this.varIdents = Sets.newHashSet();
        }

        protected abstract FrameType getType();

        private void addIdent(DetailAST identToAdd) {
            this.varIdents.add(identToAdd);
        }

        protected AbstractFrame getParent() {
            return this.parent;
        }

        protected String getFrameName() {
            return this.frameNameIdent.getText();
        }

        public DetailAST getFrameNameIdent() {
            return this.frameNameIdent;
        }

        protected boolean containsFieldOrVariable(DetailAST nameToFind) {
            return this.containsFieldOrVariableDef(this.varIdents, nameToFind);
        }

        protected AbstractFrame getIfContains(DetailAST nameToFind, boolean lookForMethod) {
            AbstractFrame frame = !lookForMethod && this.containsFieldOrVariable(nameToFind) ? this : this.parent.getIfContains(nameToFind, lookForMethod);
            return frame;
        }

        protected boolean containsFieldOrVariableDef(Set<DetailAST> set, DetailAST ident) {
            boolean result = false;
            for (DetailAST ast : set) {
                if (!this.isProperDefinition(ident, ast)) continue;
                result = true;
                break;
            }
            return result;
        }

        protected boolean isProperDefinition(DetailAST ident, DetailAST ast) {
            String nameToFind = ident.getText();
            return nameToFind.equals(ast.getText()) && AbstractFrame.checkPosition(ast, ident);
        }

        private static boolean checkPosition(DetailAST ast1, DetailAST ast2) {
            boolean result = false;
            if (ast1.getLineNo() < ast2.getLineNo() || ast1.getLineNo() == ast2.getLineNo() && ast1.getColumnNo() < ast2.getColumnNo()) {
                result = true;
            }
            return result;
        }
    }

    private static enum FrameType {
        CLASS_FRAME,
        CTOR_FRAME,
        METHOD_FRAME,
        BLOCK_FRAME;

    }
}

