/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import java.io.File;

public final class Utils {
    private Utils() {
    }

    public static boolean fileExtensionMatches(File file, String[] fileExtensions) {
        boolean result = false;
        if (fileExtensions == null || fileExtensions.length == 0) {
            result = true;
        } else {
            String[] withDotExtensions = new String[fileExtensions.length];
            for (int i = 0; i < fileExtensions.length; ++i) {
                String extension = fileExtensions[i];
                withDotExtensions[i] = extension.startsWith(".") ? extension : "." + extension;
            }
            String fileName = file.getName();
            for (String fileExtension : withDotExtensions) {
                if (!fileName.endsWith(fileExtension)) continue;
                result = true;
            }
        }
        return result;
    }
}

