/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.AbstractFormatCheck;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public class TrailingCommentCheck
extends AbstractFormatCheck {
    private static final String DEFAULT_FORMAT = "^[\\s\\}\\);]*$";
    private Pattern legalComment;

    public void setLegalComment(String format) throws ConversionException {
        try {
            this.legalComment = Utils.getPattern(format);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("unable to parse " + format, (Throwable)e);
        }
    }

    public TrailingCommentCheck() throws ConversionException {
        super(DEFAULT_FORMAT);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[0];
    }

    @Override
    public void visitToken(DetailAST ast) {
        throw new IllegalStateException("visitToken() shouldn't be called.");
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        Pattern blankLinePattern = this.getRegexp();
        ImmutableMap<Integer, TextBlock> cppComments = this.getFileContents().getCppComments();
        ImmutableMap<Integer, List<TextBlock>> cComments = this.getFileContents().getCComments();
        HashSet lines = Sets.newHashSet();
        lines.addAll(cppComments.keySet());
        lines.addAll(cComments.keySet());
        for (Integer lineNo : lines) {
            String line = this.getLines()[lineNo - 1];
            String lineBefore = "";
            TextBlock comment = null;
            if (cppComments.containsKey(lineNo)) {
                comment = (TextBlock)cppComments.get(lineNo);
                lineBefore = line.substring(0, comment.getStartColNo());
            } else if (cComments.containsKey(lineNo)) {
                String lineAfter;
                List commentList = (List)cComments.get(lineNo);
                comment = (TextBlock)commentList.get(commentList.size() - 1);
                lineBefore = line.substring(0, comment.getStartColNo());
                if (comment.getText().length == 1 && !"".equals(lineAfter = line.substring(comment.getEndColNo() + 1).trim())) continue;
            }
            if (comment == null || blankLinePattern.matcher(lineBefore).find() || this.isLegalComment(comment)) continue;
            this.log((int)lineNo, "trailing.comments", new Object[0]);
        }
    }

    private boolean isLegalComment(TextBlock comment) {
        if (this.legalComment == null) {
            return false;
        }
        if (comment.getStartLineNo() != comment.getEndLineNo()) {
            return false;
        }
        String commentText = comment.getText()[0];
        if ((commentText = commentText.substring(2)).endsWith("*/")) {
            commentText = commentText.substring(0, commentText.length() - 2);
        }
        commentText = commentText.trim();
        return this.legalComment.matcher(commentText).find();
    }
}

