/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Map;
import java.util.Set;

public class EqualsHashCodeCheck
extends Check {
    private final Map<DetailAST, DetailAST> objBlockEquals = Maps.newHashMap();
    private final Set<DetailAST> objBlockWithHashCode = Sets.newHashSet();

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.objBlockEquals.clear();
        this.objBlockWithHashCode.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        DetailAST type = ast.findFirstToken(13);
        DetailAST methodName = ast.findFirstToken(58);
        DetailAST parameters = ast.findFirstToken(20);
        if (type.getFirstChild().getType() == 50 && "equals".equals(methodName.getText()) && modifiers.branchContains(62) && parameters.getChildCount() == 1 && this.isObjectParam((AST)parameters.getFirstChild())) {
            this.objBlockEquals.put(ast.getParent(), ast);
        } else if (type.getFirstChild().getType() == 54 && "hashCode".equals(methodName.getText()) && modifiers.branchContains(62) && parameters.getFirstChild() == null) {
            this.objBlockWithHashCode.add(ast.getParent());
        }
    }

    private boolean isObjectParam(AST firstChild) {
        AST modifiers = firstChild.getFirstChild();
        AST type = modifiers.getNextSibling();
        switch (type.getFirstChild().getType()) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        Set<DetailAST> equalsDefs = this.objBlockEquals.keySet();
        for (DetailAST objBlock : equalsDefs) {
            if (this.objBlockWithHashCode.contains((Object)objBlock)) continue;
            DetailAST equalsAST = this.objBlockEquals.get((Object)objBlock);
            this.log(equalsAST.getLineNo(), equalsAST.getColumnNo(), "equals.noHashCode", new Object[0]);
        }
        this.objBlockEquals.clear();
        this.objBlockWithHashCode.clear();
    }
}

