/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.api.Utils;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocTag;
import com.puppycrawl.tools.checkstyle.checks.javadoc.JavadocUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnusedImportsCheck
extends Check {
    private static final Pattern CLASS_NAME = Pattern.compile("((:?[\\p{L}_$][\\p{L}\\p{N}_$]*\\.)*[\\p{L}_$][\\p{L}\\p{N}_$]*)");
    private static final Pattern FIRST_CLASS_NAME = Pattern.compile("^" + CLASS_NAME);
    private static final Pattern ARGUMENT_NAME = Pattern.compile("[(,]\\s*" + CLASS_NAME.pattern());
    private boolean collect;
    private boolean processJavadoc;
    private final Set<FullIdent> imports = Sets.newHashSet();
    private final Set<String> referenced = Sets.newHashSet();

    public void setProcessJavadoc(boolean value) {
        this.processJavadoc = value;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.collect = false;
        this.imports.clear();
        this.referenced.clear();
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        for (FullIdent imp : this.imports) {
            if (this.referenced.contains(Utils.baseClassname(imp.getText()))) continue;
            this.log(imp.getLineNo(), imp.getColumnNo(), "import.unused", imp.getText());
        }
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{58, 30, 152, 16, 157, 161, 154, 155, 14, 15, 9, 8, 10};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() == 58) {
            if (this.collect) {
                this.processIdent(ast);
            }
        } else if (ast.getType() == 30) {
            this.processImport(ast);
        } else if (ast.getType() == 152) {
            this.processStaticImport(ast);
        } else {
            this.collect = true;
            if (this.processJavadoc) {
                this.processJavadoc(ast);
            }
        }
    }

    private void processIdent(DetailAST ast) {
        DetailAST parent = ast.getParent();
        int parentType = parent.getType();
        if (parentType != 59 && parentType != 9 || parentType == 59 && ast.getNextSibling() != null) {
            this.referenced.add(ast.getText());
        }
    }

    private void processImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdentBelow(ast);
        if (name != null && !name.getText().endsWith(".*")) {
            this.imports.add(name);
        }
    }

    private void processStaticImport(DetailAST ast) {
        FullIdent name = FullIdent.createFullIdent(ast.getFirstChild().getNextSibling());
        if (name != null && !name.getText().endsWith(".*")) {
            this.imports.add(name);
        }
    }

    private void processJavadoc(DetailAST ast) {
        int lineNo;
        FileContents contents = this.getFileContents();
        TextBlock cmt = contents.getJavadocBefore(lineNo = ast.getLineNo());
        if (cmt != null) {
            this.referenced.addAll(this.processJavadoc(cmt));
        }
    }

    private Set<String> processJavadoc(TextBlock cmt) {
        HashSet<String> references = new HashSet<String>();
        for (JavadocTag tag : this.getValidTags(cmt, JavadocUtils.JavadocTagType.INLINE)) {
            if (!tag.canReferenceImports()) continue;
            references.addAll(this.processJavadocTag(tag));
        }
        for (JavadocTag tag : this.getValidTags(cmt, JavadocUtils.JavadocTagType.BLOCK)) {
            if (!tag.canReferenceImports()) continue;
            references.addAll(this.matchPattern(tag.getArg1(), FIRST_CLASS_NAME));
        }
        return references;
    }

    private List<JavadocTag> getValidTags(TextBlock cmt, JavadocUtils.JavadocTagType tagType) {
        return JavadocUtils.getJavadocTags(cmt, tagType).getValidTags();
    }

    private Set<String> processJavadocTag(JavadocTag tag) {
        HashSet<String> references = new HashSet<String>();
        String identifier = tag.getArg1().trim();
        for (Pattern pattern : new Pattern[]{FIRST_CLASS_NAME, ARGUMENT_NAME}) {
            references.addAll(this.matchPattern(identifier, pattern));
        }
        return references;
    }

    private Set<String> matchPattern(String identifier, Pattern pattern) {
        HashSet<String> references = new HashSet<String>();
        Matcher matcher = pattern.matcher(identifier);
        while (matcher.find()) {
            references.add(matcher.group(1));
        }
        return references;
    }
}

