/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;

public class MethodLengthCheck
extends Check {
    private boolean countEmpty = true;
    private static final int DEFAULT_MAX_LINES = 150;
    private int max = 150;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST openingBrace = ast.findFirstToken(7);
        if (openingBrace != null) {
            DetailAST closingBrace = openingBrace.findFirstToken(73);
            int length = closingBrace.getLineNo() - openingBrace.getLineNo() + 1;
            if (!this.countEmpty) {
                FileContents contents = this.getFileContents();
                int lastLine = closingBrace.getLineNo();
                for (int i = openingBrace.getLineNo() - 1; i < lastLine; ++i) {
                    if (!contents.lineIsBlank(i) && !contents.lineIsComment(i)) continue;
                    --length;
                }
            }
            if (length > this.max) {
                this.log(ast.getLineNo(), ast.getColumnNo(), "maxLen.method", length, this.max);
            }
        }
    }

    public void setMax(int length) {
        this.max = length;
    }

    public void setCountEmpty(boolean countEmpty) {
        this.countEmpty = countEmpty;
    }
}

