/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FastStack;
import com.puppycrawl.tools.checkstyle.api.Utils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PackageNamesLoader
extends AbstractLoader {
    private static final String DTD_PUBLIC_ID = "-//Puppy Crawl//DTD Package Names 1.0//EN";
    private static final String DTD_RESOURCE_NAME = "com/puppycrawl/tools/checkstyle/packages_1_0.dtd";
    private static final String CHECKSTYLE_PACKAGES = "checkstyle_packages.xml";
    private final FastStack<String> packageStack = FastStack.newInstance();
    private final Set<String> packageNames = Sets.newLinkedHashSet();

    private PackageNamesLoader() throws ParserConfigurationException, SAXException {
        super(DTD_PUBLIC_ID, DTD_RESOURCE_NAME);
    }

    private Set<String> getPackageNames() {
        return this.packageNames;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if ("package".equals(qName)) {
            String name = atts.getValue("name");
            if (name == null) {
                throw new SAXException("missing package name");
            }
            this.packageStack.push(name);
        }
    }

    private String getPackageName() {
        StringBuilder buf = new StringBuilder();
        for (String subPackage : this.packageStack) {
            buf.append(subPackage);
            if (subPackage.endsWith(".")) continue;
            buf.append(".");
        }
        return buf.toString();
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if ("package".equals(qName)) {
            this.packageNames.add(this.getPackageName());
            this.packageStack.pop();
        }
    }

    public static Set<String> getPackageNames(ClassLoader classLoader) throws CheckstyleException {
        Enumeration<URL> packageFiles = null;
        try {
            packageFiles = classLoader.getResources(CHECKSTYLE_PACKAGES);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to get package file resources", e);
        }
        PackageNamesLoader namesLoader = PackageNamesLoader.newPackageNamesLoader();
        while (null != packageFiles && packageFiles.hasMoreElements()) {
            URL packageFile = packageFiles.nextElement();
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(packageFile.openStream());
                InputSource source = new InputSource(stream);
                PackageNamesLoader.loadPackageNamesSource(source, "default package names", namesLoader);
            }
            catch (IOException e) {
                try {
                    throw new CheckstyleException("unable to open " + packageFile, e);
                }
                catch (Throwable throwable) {
                    Utils.closeQuietly(stream);
                    throw throwable;
                }
            }
            Utils.closeQuietly(stream);
        }
        return namesLoader.getPackageNames();
    }

    private static PackageNamesLoader newPackageNamesLoader() throws CheckstyleException {
        try {
            return new PackageNamesLoader();
        }
        catch (ParserConfigurationException e) {
            throw new CheckstyleException("unable to create PackageNamesLoader ", e);
        }
        catch (SAXException e) {
            throw new CheckstyleException("unable to create PackageNamesLoader - " + e.getMessage(), e);
        }
    }

    private static void loadPackageNamesSource(InputSource source, String sourceName, PackageNamesLoader nameLoader) throws CheckstyleException {
        try {
            nameLoader.parseInputSource(source);
        }
        catch (SAXException e) {
            throw new CheckstyleException("unable to parse " + sourceName + " - " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CheckstyleException("unable to read " + sourceName, e);
        }
    }
}

