/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.api.Comment;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.grammars.CommentListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public final class FileContents
implements CommentListener {
    private static final String MATCH_SINGLELINE_COMMENT_PAT = "^\\s*//.*$";
    private static final Pattern MATCH_SINGLELINE_COMMENT = Pattern.compile("^\\s*//.*$");
    private final String filename;
    private final FileText text;
    private final Map<Integer, TextBlock> javadocComments = Maps.newHashMap();
    private final Map<Integer, TextBlock> cppComments = Maps.newHashMap();
    private final Map<Integer, List<TextBlock>> clangComments = Maps.newHashMap();

    @Deprecated
    public FileContents(String filename, String[] lines) {
        this.filename = filename;
        this.text = FileText.fromLines(new File(filename), Arrays.asList(lines));
    }

    public FileContents(FileText text) {
        this.filename = text.getFile().toString();
        this.text = text;
    }

    @Override
    public void reportSingleLineComment(String type, int startLineNo, int startColNo) {
        this.reportCppComment(startLineNo, startColNo);
    }

    @Override
    public void reportBlockComment(String type, int startLineNo, int startColNo, int endLineNo, int endColNo) {
        this.reportCComment(startLineNo, startColNo, endLineNo, endColNo);
    }

    public void reportCppComment(int startLineNo, int startColNo) {
        String line = this.line(startLineNo - 1);
        String[] txt = new String[]{line.substring(startColNo)};
        Comment comment = new Comment(txt, startColNo, startLineNo, line.length() - 1);
        this.cppComments.put(startLineNo, comment);
    }

    public ImmutableMap<Integer, TextBlock> getCppComments() {
        return ImmutableMap.copyOf(this.cppComments);
    }

    public void reportCComment(int startLineNo, int startColNo, int endLineNo, int endColNo) {
        String[] cc = this.extractCComment(startLineNo, startColNo, endLineNo, endColNo);
        Comment comment = new Comment(cc, startColNo, endLineNo, endColNo);
        if (this.clangComments.containsKey(startLineNo)) {
            List<TextBlock> entries = this.clangComments.get(startLineNo);
            entries.add(comment);
        } else {
            ArrayList entries = Lists.newArrayList();
            entries.add(comment);
            this.clangComments.put(startLineNo, entries);
        }
        if (this.line(startLineNo - 1).indexOf("/**", startColNo) != -1) {
            this.javadocComments.put(endLineNo - 1, comment);
        }
    }

    public ImmutableMap<Integer, List<TextBlock>> getCComments() {
        return ImmutableMap.copyOf(this.clangComments);
    }

    private String[] extractCComment(int startLineNo, int startColNo, int endLineNo, int endColNo) {
        String[] retVal;
        if (startLineNo == endLineNo) {
            retVal = new String[]{this.line(startLineNo - 1).substring(startColNo, endColNo + 1)};
        } else {
            retVal = new String[endLineNo - startLineNo + 1];
            retVal[0] = this.line(startLineNo - 1).substring(startColNo);
            for (int i = startLineNo; i < endLineNo; ++i) {
                retVal[i - startLineNo + 1] = this.line(i);
            }
            retVal[retVal.length - 1] = this.line(endLineNo - 1).substring(0, endColNo + 1);
        }
        return retVal;
    }

    public TextBlock getJavadocBefore(int lineNoBefore) {
        int lineNo;
        for (lineNo = lineNoBefore - 2; lineNo > 0 && (this.lineIsBlank(lineNo) || this.lineIsComment(lineNo)); --lineNo) {
        }
        return this.javadocComments.get(lineNo);
    }

    private String line(int lineNo) {
        return this.text.get(lineNo);
    }

    public FileText getText() {
        return this.text;
    }

    public String[] getLines() {
        return this.text.toLinesArray();
    }

    public String getLine(int index) {
        return this.text.get(index);
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean lineIsBlank(int lineNo) {
        return "".equals(this.line(lineNo).trim());
    }

    public boolean lineIsComment(int lineNo) {
        return MATCH_SINGLELINE_COMMENT.matcher(this.line(lineNo)).matches();
    }

    public boolean hasIntersectionWithComment(int startLineNo, int startColNo, int endLineNo, int endColNo) {
        Collection<List<TextBlock>> values = this.clangComments.values();
        for (List<TextBlock> row : values) {
            for (TextBlock comment : row) {
                if (!comment.intersects(startLineNo, startColNo, endLineNo, endColNo)) continue;
                return true;
            }
        }
        for (int lineNumber = startLineNo; lineNumber <= endLineNo; ++lineNumber) {
            TextBlock comment = this.cppComments.get(lineNumber);
            if (comment == null || !comment.intersects(startLineNo, startColNo, endLineNo, endColNo)) continue;
            return true;
        }
        return false;
    }

    public boolean inPackageInfo() {
        return this.getFilename().endsWith("package-info.java");
    }
}

