/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.ImmutableMap;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.beanutils.ConversionException;

public final class Utils {
    private static final ImmutableMap<String, Integer> TOKEN_NAME_TO_VALUE;
    private static final String[] TOKEN_VALUE_TO_NAME;

    private Utils() {
    }

    public static boolean fileExtensionMatches(File file, String ... fileExtensions) {
        boolean result = false;
        if (fileExtensions == null || fileExtensions.length == 0) {
            result = true;
        } else {
            String[] withDotExtensions = new String[fileExtensions.length];
            for (int i = 0; i < fileExtensions.length; ++i) {
                String extension = fileExtensions[i];
                withDotExtensions[i] = Utils.startsWithChar(extension, '.') ? extension : "." + extension;
            }
            String fileName = file.getName();
            for (String fileExtension : withDotExtensions) {
                if (!fileName.endsWith(fileExtension)) continue;
                result = true;
            }
        }
        return result;
    }

    public static boolean whitespaceBefore(int index, String line) {
        for (int i = 0; i < index; ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int lengthMinusTrailingWhitespace(String line) {
        int len = line.length();
        for (int i = len - 1; i >= 0 && Character.isWhitespace(line.charAt(i)); --i) {
            --len;
        }
        return len;
    }

    public static int lengthExpandedTabs(String string, int toIdx, int tabWidth) {
        int len = 0;
        for (int idx = 0; idx < toIdx; ++idx) {
            if (string.charAt(idx) == '\t') {
                len = (len / tabWidth + 1) * tabWidth;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static boolean isPatternValid(String pattern) {
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    public static Pattern createPattern(String pattern) throws ConversionException {
        try {
            return Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConversionException("Failed to initialise regular expression " + pattern, (Throwable)e);
        }
    }

    public static String baseClassname(String type) {
        int i = type.lastIndexOf(46);
        return i == -1 ? type : type.substring(i + 1);
    }

    public static String relativizeAndNormalizePath(String baseDirectory, String path) {
        if (baseDirectory == null) {
            return path;
        }
        Path pathAbsolute = Paths.get(path, new String[0]).normalize();
        Path pathBase = Paths.get(baseDirectory, new String[0]).normalize();
        return pathBase.relativize(pathAbsolute).toString();
    }

    public static boolean startsWithChar(String string, char prefix) {
        return string.length() > 0 && string.charAt(0) == prefix;
    }

    public static boolean endsWithChar(String string, char suffix) {
        return string.length() > 0 && string.charAt(string.length() - 1) == suffix;
    }

    public static String getTokenName(int iD) {
        if (iD > TOKEN_VALUE_TO_NAME.length - 1) {
            throw new IllegalArgumentException("given id " + iD);
        }
        String name = TOKEN_VALUE_TO_NAME[iD];
        if (name == null) {
            throw new IllegalArgumentException("given id " + iD);
        }
        return name;
    }

    public static int getTokenId(String name) {
        Integer id = (Integer)TOKEN_NAME_TO_VALUE.get((Object)name);
        if (id == null) {
            throw new IllegalArgumentException("given name " + name);
        }
        return id;
    }

    public static String getShortDescription(String name) {
        if (!TOKEN_NAME_TO_VALUE.containsKey((Object)name)) {
            throw new IllegalArgumentException("given name " + name);
        }
        String tokentypes = "com.puppycrawl.tools.checkstyle.api.tokentypes";
        ResourceBundle bundle = ResourceBundle.getBundle("com.puppycrawl.tools.checkstyle.api.tokentypes");
        return bundle.getString(name);
    }

    public static boolean isCommentType(int type) {
        return type == 144 || type == 145 || type == 182 || type == 183;
    }

    public static boolean isCommentType(String type) {
        return Utils.isCommentType(Utils.getTokenId(type));
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Field[] fields = TokenTypes.class.getDeclaredFields();
        String[] tempTokenValueToName = new String[]{};
        for (Field f : fields) {
            if (f.getType() != Integer.TYPE) continue;
            String name = f.getName();
            try {
                int tokenValue = f.getInt(name);
                builder.put((Object)name, (Object)tokenValue);
                if (tokenValue > tempTokenValueToName.length - 1) {
                    String[] temp = new String[tokenValue + 1];
                    System.arraycopy(tempTokenValueToName, 0, temp, 0, tempTokenValueToName.length);
                    tempTokenValueToName = temp;
                }
                tempTokenValueToName[tokenValue] = name;
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalStateException("Failed to instantiate collection of Java tokens", e);
            }
        }
        TOKEN_NAME_TO_VALUE = builder.build();
        TOKEN_VALUE_TO_NAME = tempTokenValueToName;
    }
}

