/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public final class ThrowsCountCheck
extends Check {
    public static final String MSG_KEY = "throws.count";
    private static final int DEFAULT_MAX = 1;
    private boolean ignorePrivateMethods = true;
    private int max;

    public ThrowsCountCheck() {
        this.setMax(1);
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{81};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{81};
    }

    public int getMax() {
        return this.max;
    }

    public void setIgnorePrivateMethods(boolean ignorePrivateMethods) {
        this.ignorePrivateMethods = ignorePrivateMethods;
    }

    public void setMax(int max) {
        this.max = max;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (ast.getType() != 81) {
            throw new IllegalStateException(ast.toString());
        }
        this.visitLiteralThrows(ast);
    }

    private void visitLiteralThrows(DetailAST ast) {
        int count;
        if (!(this.ignorePrivateMethods && ThrowsCountCheck.isInPrivateMethod(ast) || ThrowsCountCheck.isOverriding(ast) || (count = (ast.getChildCount() + 1) / 2) <= this.getMax())) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, count, this.getMax());
        }
    }

    private static boolean isOverriding(DetailAST ast) {
        DetailAST modifiers = ast.getParent().findFirstToken(5);
        boolean isOverriding = false;
        if (modifiers.branchContains(159)) {
            for (DetailAST child = modifiers.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getType() != 159 || !"Override".equals(ThrowsCountCheck.getAnnotationName(child))) continue;
                isOverriding = true;
            }
        }
        return isOverriding;
    }

    private static String getAnnotationName(DetailAST annotation) {
        DetailAST dotAst = annotation.findFirstToken(59);
        String name = dotAst != null ? dotAst.findFirstToken(58).getText() : annotation.findFirstToken(58).getText();
        return name;
    }

    private static boolean isInPrivateMethod(DetailAST ast) {
        DetailAST methodModifiers = ast.getParent().findFirstToken(5);
        return methodModifiers.findFirstToken(61) != null;
    }
}

