/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;
import com.puppycrawl.tools.checkstyle.utils.CheckUtils;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.Optional;

public class ParameterNameCheck
extends AbstractNameCheck {
    private boolean ignoreOverridden;
    private Scope scope = Scope.ANONINNER;
    private Scope excludeScope;

    public ParameterNameCheck() {
        super("^[a-z][a-zA-Z0-9]*$");
    }

    public void setIgnoreOverridden(boolean ignoreOverridden) {
        this.ignoreOverridden = ignoreOverridden;
    }

    public void setScope(String from) {
        this.scope = Scope.getInstance(from);
    }

    public void setExcludeScope(String excludeScope) {
        this.excludeScope = Scope.getInstance(excludeScope);
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{21};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    protected boolean mustCheckName(DetailAST ast) {
        boolean isDefault;
        boolean checkName = true;
        boolean bl = isDefault = this.scope == Scope.ANONINNER && this.excludeScope == null;
        if (this.ignoreOverridden && ParameterNameCheck.isOverriddenMethod(ast) || ast.getParent().getType() == 96 || CheckUtils.isReceiverParameter(ast) || !isDefault && !this.matchScope(ParameterNameCheck.calculateScope(ast))) {
            checkName = false;
        }
        return checkName;
    }

    private static Scope calculateScope(DetailAST ast) {
        DetailAST params = ast.getParent();
        DetailAST meth = params.getParent();
        Scope scope = Scope.PRIVATE;
        if (meth.getType() == 9 || meth.getType() == 8) {
            if (ScopeUtils.isInInterfaceOrAnnotationBlock(ast)) {
                scope = Scope.PUBLIC;
            } else {
                DetailAST mods = meth.findFirstToken(5);
                scope = ScopeUtils.getScopeFromMods(mods);
            }
        }
        return scope;
    }

    private boolean matchScope(Scope nodeScope) {
        return nodeScope.isIn(this.scope) && (this.excludeScope == null || !nodeScope.isIn(this.excludeScope));
    }

    private static boolean isOverriddenMethod(DetailAST ast) {
        Optional<DetailAST> overrideToken;
        boolean overridden = false;
        DetailAST parent = ast.getParent().getParent();
        Optional<DetailAST> annotation = Optional.ofNullable(parent.getFirstChild().getFirstChild());
        if (annotation.isPresent() && annotation.get().getType() == 159 && (overrideToken = Optional.ofNullable(annotation.get().findFirstToken(58))).isPresent() && "Override".equals(overrideToken.get().getText())) {
            overridden = true;
        }
        return overridden;
    }
}

