/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class CommonUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private static final String UNABLE_TO_FIND_EXCEPTION_PREFIX = "Unable to find: ";

    private CommonUtils() {
    }

    public static Pattern createPattern(String pattern) {
        return CommonUtils.createPattern(pattern, 0);
    }

    public static Pattern createPattern(String pattern, int flags) {
        try {
            return Pattern.compile(pattern, flags);
        }
        catch (PatternSyntaxException ex) {
            throw new IllegalArgumentException("Failed to initialise regular expression " + pattern, ex);
        }
    }

    public static boolean matchesFileExtension(File file, String ... fileExtensions) {
        boolean result = false;
        if (fileExtensions == null || fileExtensions.length == 0) {
            result = true;
        } else {
            String[] withDotExtensions = new String[fileExtensions.length];
            for (int i = 0; i < fileExtensions.length; ++i) {
                String extension = fileExtensions[i];
                withDotExtensions[i] = CommonUtils.startsWithChar(extension, '.') ? extension : "." + extension;
            }
            String fileName = file.getName();
            for (String fileExtension : withDotExtensions) {
                if (!fileName.endsWith(fileExtension)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static boolean hasWhitespaceBefore(int index, String line) {
        boolean result = true;
        for (int i = 0; i < index; ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    public static int lengthMinusTrailingWhitespace(String line) {
        int len = line.length();
        for (int i = len - 1; i >= 0 && Character.isWhitespace(line.charAt(i)); --i) {
            --len;
        }
        return len;
    }

    public static int lengthExpandedTabs(String inputString, int toIdx, int tabWidth) {
        int len = 0;
        for (int idx = 0; idx < toIdx; ++idx) {
            if (inputString.charAt(idx) == '\t') {
                len = (len / tabWidth + 1) * tabWidth;
                continue;
            }
            ++len;
        }
        return len;
    }

    public static boolean isPatternValid(String pattern) {
        boolean isValid = true;
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException ignored) {
            isValid = false;
        }
        return isValid;
    }

    public static String baseClassName(String type) {
        int index = type.lastIndexOf(46);
        String className = index == -1 ? type : type.substring(index + 1);
        return className;
    }

    public static String relativizeAndNormalizePath(String baseDirectory, String path) {
        String resultPath;
        if (baseDirectory == null) {
            resultPath = path;
        } else {
            Path pathAbsolute = Paths.get(path, new String[0]).normalize();
            Path pathBase = Paths.get(baseDirectory, new String[0]).normalize();
            resultPath = pathBase.relativize(pathAbsolute).toString();
        }
        return resultPath;
    }

    public static boolean startsWithChar(String value, char prefix) {
        return !value.isEmpty() && value.charAt(0) == prefix;
    }

    public static boolean endsWithChar(String value, char suffix) {
        return !value.isEmpty() && value.charAt(value.length() - 1) == suffix;
    }

    public static <T> Constructor<T> getConstructor(Class<T> targetClass, Class<?> ... parameterTypes) {
        try {
            return targetClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static <T> T invokeConstructor(Constructor<T> constructor, Object ... parameters) {
        try {
            return constructor.newInstance(parameters);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot close the stream", ex);
            }
        }
    }

    public static URI getUriByFilename(String filename) throws CheckstyleException {
        URI uri;
        try {
            URL url = new URL(filename);
            uri = url.toURI();
        }
        catch (MalformedURLException | URISyntaxException ignored) {
            uri = null;
        }
        if (uri == null) {
            File file = new File(filename);
            if (file.exists()) {
                uri = file.toURI();
            } else {
                try {
                    URL configUrl = CommonUtils.class.getResource(filename);
                    if (configUrl == null) {
                        throw new CheckstyleException(UNABLE_TO_FIND_EXCEPTION_PREFIX + filename);
                    }
                    uri = configUrl.toURI();
                }
                catch (URISyntaxException ex) {
                    throw new CheckstyleException(UNABLE_TO_FIND_EXCEPTION_PREFIX + filename, ex);
                }
            }
        }
        return uri;
    }

    public static String fillTemplateWithStringsByRegexp(String template, String lineToPlaceInTemplate, Pattern regexp) {
        Matcher matcher = regexp.matcher(lineToPlaceInTemplate);
        String result = template;
        if (matcher.find()) {
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                result = result.replaceAll("\\$" + i, matcher.group(i));
            }
        }
        return result;
    }

    public static String getFileNameWithoutExtension(String fullFilename) {
        String fileName = new File(fullFilename).getName();
        int dotIndex = fileName.lastIndexOf(46);
        String fileNameWithoutExtension = dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
        return fileNameWithoutExtension;
    }

    public static String getFileExtension(String fileNameWithExtension) {
        String fileName = Paths.get(fileNameWithExtension, new String[0]).toString();
        int dotIndex = fileName.lastIndexOf(46);
        String extension = dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
        return extension;
    }

    public static boolean isIdentifier(String str) {
        boolean isIdentifier = !str.isEmpty();
        for (int i = 0; isIdentifier && i < str.length(); ++i) {
            isIdentifier = i == 0 ? Character.isJavaIdentifierStart(str.charAt(0)) : Character.isJavaIdentifierPart(str.charAt(i));
        }
        return isIdentifier;
    }

    public static boolean isName(String str) {
        boolean isName = !str.isEmpty();
        String[] identifiers = str.split("\\.", -1);
        for (int i = 0; isName && i < identifiers.length; ++i) {
            isName = CommonUtils.isIdentifier(identifiers[i]);
        }
        return isName;
    }

    public static boolean isBlank(String value) {
        boolean result = true;
        if (value != null && !value.isEmpty()) {
            for (int i = 0; i < value.length(); ++i) {
                if (Character.isWhitespace(value.charAt(i))) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

