/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.AbstractViolationReporter;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessages;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractCheck
extends AbstractViolationReporter {
    private static final int DEFAULT_TAB_WIDTH = 8;
    private final Set<String> tokens = new HashSet<String>();
    private FileContents fileContents;
    private LocalizedMessages messages;
    private int tabWidth = 8;
    private ClassLoader classLoader;

    public abstract int[] getDefaultTokens();

    public abstract int[] getAcceptableTokens();

    public abstract int[] getRequiredTokens();

    public boolean isCommentNodesRequired() {
        return false;
    }

    public final void setTokens(String ... strRep) {
        Collections.addAll(this.tokens, strRep);
    }

    public final Set<String> getTokenNames() {
        return Collections.unmodifiableSet(this.tokens);
    }

    public final void setMessages(LocalizedMessages messages) {
        this.messages = messages;
    }

    public void init() {
    }

    public void destroy() {
    }

    public void beginTree(DetailAST rootAST) {
    }

    public void finishTree(DetailAST rootAST) {
    }

    public void visitToken(DetailAST ast) {
    }

    public void leaveToken(DetailAST ast) {
    }

    public final String[] getLines() {
        return this.fileContents.getLines();
    }

    public final String getLine(int index) {
        return this.fileContents.getLine(index);
    }

    public final void setFileContents(FileContents contents) {
        this.fileContents = contents;
    }

    public final FileContents getFileContents() {
        return this.fileContents;
    }

    public final void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    protected final int getTabWidth() {
        return this.tabWidth;
    }

    public final void setTabWidth(int tabWidth) {
        this.tabWidth = tabWidth;
    }

    @Override
    public final void log(int line, String key, Object ... args) {
        this.messages.add(new LocalizedMessage(line, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }

    @Override
    public final void log(int lineNo, int colNo, String key, Object ... args) {
        int col = 1 + CommonUtils.lengthExpandedTabs(this.getLines()[lineNo - 1], colNo, this.tabWidth);
        this.messages.add(new LocalizedMessage(lineNo, col, this.getMessageBundle(), key, args, this.getSeverityLevel(), this.getId(), this.getClass(), this.getCustomMessages().get(key)));
    }
}

