/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class FinalLocalVariableCheck
extends AbstractCheck {
    public static final String MSG_KEY = "final.variable";
    private static final int[] ASSIGN_OPERATOR_TYPES = new int[]{25, 26, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 130};
    private static final int[] LOOP_TYPES = new int[]{91, 84, 85};
    private final Deque<ScopeData> scopeStack = new ArrayDeque<ScopeData>();
    private final Deque<Deque<DetailAST>> prevScopeUninitializedVariables = new ArrayDeque<Deque<DetailAST>>();
    private final Deque<Deque<DetailAST>> currentScopeAssignedVariables = new ArrayDeque<Deque<DetailAST>>();
    private boolean validateEnhancedForLoopVariable;

    public final void setValidateEnhancedForLoopVariable(boolean validateEnhancedForLoopVariable) {
        this.validateEnhancedForLoopVariable = validateEnhancedForLoopVariable;
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{58, 8, 9, 7, 6, 86};
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{58, 8, 9, 7, 6, 86, 10};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{58, 8, 9, 7, 6, 86, 10, 21};
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 6: 
            case 8: 
            case 9: {
                this.scopeStack.push(new ScopeData());
                break;
            }
            case 7: {
                this.currentScopeAssignedVariables.push(new ArrayDeque());
                if (ast.getParent().getType() == 33 && ast.getParent().getParent().findFirstToken(33) != ast.getParent()) break;
                this.storePrevScopeUninitializedVariableData();
                this.scopeStack.push(new ScopeData());
                break;
            }
            case 21: {
                if (FinalLocalVariableCheck.isInLambda(ast) || ast.branchContains(39) || FinalLocalVariableCheck.isInAbstractOrNativeMethod(ast) || ScopeUtils.isInInterfaceBlock(ast) || FinalLocalVariableCheck.isMultipleTypeCatch(ast)) break;
                this.insertParameter(ast);
                break;
            }
            case 10: {
                if (ast.getParent().getType() == 6 || ast.branchContains(39) || FinalLocalVariableCheck.isVariableInForInit(ast) || !this.shouldCheckEnhancedForLoopVariable(ast)) break;
                this.insertVariable(ast);
                break;
            }
            case 58: {
                int parentType = ast.getParent().getType();
                if (!FinalLocalVariableCheck.isAssignOperator(parentType) || !FinalLocalVariableCheck.isFirstChild(ast)) break;
                Optional<FinalVariableCandidate> candidate = this.getFinalCandidate(ast);
                if (candidate.isPresent()) {
                    FinalLocalVariableCheck.determineAssignmentConditions(ast, candidate.get());
                    this.currentScopeAssignedVariables.peek().add(ast);
                }
                this.removeFinalVariableCandidateFromStack(ast);
                break;
            }
            case 86: {
                this.scopeStack.peek().containsBreak = true;
                break;
            }
            default: {
                throw new IllegalStateException("Incorrect token type");
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        Map scope = null;
        switch (ast.getType()) {
            case 6: 
            case 8: 
            case 9: {
                scope = this.scopeStack.pop().scope;
                break;
            }
            case 7: {
                Deque<DetailAST> prevScopeUnitializedVariableData = this.prevScopeUninitializedVariables.peek();
                boolean containsBreak = false;
                if (ast.getParent().getType() != 33 || FinalLocalVariableCheck.findLastChildWhichContainsSpecifiedToken(ast.getParent().getParent(), 33, 7) == ast.getParent()) {
                    containsBreak = this.scopeStack.peek().containsBreak;
                    scope = this.scopeStack.pop().scope;
                    this.prevScopeUninitializedVariables.pop();
                }
                DetailAST parent = ast.getParent();
                if (containsBreak || FinalLocalVariableCheck.shouldUpdateUninitializedVariables(parent)) {
                    this.updateAllUninitializedVariables(prevScopeUnitializedVariableData);
                }
                this.updateCurrentScopeAssignedVariables();
                break;
            }
        }
        if (scope != null) {
            for (FinalVariableCandidate candidate : scope.values()) {
                DetailAST ident = candidate.variableIdent;
                this.log(ident.getLineNo(), ident.getColumnNo(), MSG_KEY, ident.getText());
            }
        }
    }

    private void updateCurrentScopeAssignedVariables() {
        Deque<DetailAST> poppedScopeAssignedVariableData = this.currentScopeAssignedVariables.pop();
        Deque<DetailAST> currentScopeAssignedVariableData = this.currentScopeAssignedVariables.peek();
        if (currentScopeAssignedVariableData != null) {
            currentScopeAssignedVariableData.addAll(poppedScopeAssignedVariableData);
        }
    }

    private static void determineAssignmentConditions(DetailAST ident, FinalVariableCandidate candidate) {
        if (candidate.assigned) {
            if (!FinalLocalVariableCheck.isInSpecificCodeBlock(ident, 92) && !FinalLocalVariableCheck.isInSpecificCodeBlock(ident, 33)) {
                candidate.alreadyAssigned = true;
            }
        } else {
            candidate.assigned = true;
        }
    }

    private static boolean isInSpecificCodeBlock(DetailAST node, int blockType) {
        boolean returnValue = false;
        for (DetailAST token = node.getParent(); token != null; token = token.getParent()) {
            int type = token.getType();
            if (type != blockType) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    private Optional<FinalVariableCandidate> getFinalCandidate(DetailAST ast) {
        Optional<FinalVariableCandidate> result = Optional.empty();
        Iterator<ScopeData> iterator = this.scopeStack.descendingIterator();
        while (iterator.hasNext() && !result.isPresent()) {
            ScopeData scopeData = iterator.next();
            result = scopeData.findFinalVariableCandidateForAst(ast);
        }
        return result;
    }

    private void storePrevScopeUninitializedVariableData() {
        ScopeData scopeData = this.scopeStack.peek();
        ArrayDeque prevScopeUnitializedVariableData = new ArrayDeque();
        scopeData.uninitializedVariables.forEach(prevScopeUnitializedVariableData::push);
        this.prevScopeUninitializedVariables.push(prevScopeUnitializedVariableData);
    }

    private void updateAllUninitializedVariables(Deque<DetailAST> prevScopeUnitializedVariableData) {
        this.updateUninitializedVariables(prevScopeUnitializedVariableData);
        this.prevScopeUninitializedVariables.forEach(this::updateUninitializedVariables);
    }

    private void updateUninitializedVariables(Deque<DetailAST> scopeUnitializedVariableData) {
        Iterator<DetailAST> iterator = this.currentScopeAssignedVariables.peek().iterator();
        while (iterator.hasNext()) {
            DetailAST assignedVariable = iterator.next();
            for (DetailAST variable : scopeUnitializedVariableData) {
                for (ScopeData scopeData : this.scopeStack) {
                    FinalVariableCandidate candidate = (FinalVariableCandidate)scopeData.scope.get(variable.getText());
                    DetailAST storedVariable = null;
                    if (candidate != null) {
                        storedVariable = candidate.variableIdent;
                    }
                    if (storedVariable == null || !FinalLocalVariableCheck.isSameVariables(storedVariable, variable) || !FinalLocalVariableCheck.isSameVariables(assignedVariable, variable)) continue;
                    scopeData.uninitializedVariables.push(variable);
                    iterator.remove();
                }
            }
        }
    }

    private static boolean shouldUpdateUninitializedVariables(DetailAST ast) {
        return FinalLocalVariableCheck.isIfTokenWithAnElseFollowing(ast) || FinalLocalVariableCheck.isCaseTokenWithAnotherCaseFollowing(ast);
    }

    private static boolean isIfTokenWithAnElseFollowing(DetailAST ast) {
        return ast.getType() == 83 && ast.getLastChild().getType() == 92;
    }

    private static boolean isCaseTokenWithAnotherCaseFollowing(DetailAST ast) {
        return ast.getType() == 33 && FinalLocalVariableCheck.findLastChildWhichContainsSpecifiedToken(ast.getParent(), 33, 7) != ast;
    }

    private static DetailAST findLastChildWhichContainsSpecifiedToken(DetailAST ast, int childType, int containType) {
        DetailAST returnValue = null;
        for (DetailAST astIterator = ast.getFirstChild(); astIterator != null; astIterator = astIterator.getNextSibling()) {
            if (astIterator.getType() != childType || !astIterator.branchContains(containType)) continue;
            returnValue = astIterator;
        }
        return returnValue;
    }

    private boolean shouldCheckEnhancedForLoopVariable(DetailAST ast) {
        return this.validateEnhancedForLoopVariable || ast.getParent().getType() != 156;
    }

    private void insertParameter(DetailAST ast) {
        Map scope = this.scopeStack.peek().scope;
        DetailAST astNode = ast.findFirstToken(58);
        scope.put(astNode.getText(), new FinalVariableCandidate(astNode));
    }

    private void insertVariable(DetailAST ast) {
        Map scope = this.scopeStack.peek().scope;
        DetailAST astNode = ast.findFirstToken(58);
        scope.put(astNode.getText(), new FinalVariableCandidate(astNode));
        if (!FinalLocalVariableCheck.isInitialized(astNode)) {
            this.scopeStack.peek().uninitializedVariables.add(astNode);
        }
    }

    private static boolean isInitialized(DetailAST ast) {
        return ast.getParent().getLastChild().getType() == 80;
    }

    private static boolean isFirstChild(DetailAST ast) {
        return ast.getPreviousSibling() == null;
    }

    private void removeFinalVariableCandidateFromStack(DetailAST ast) {
        Iterator<ScopeData> iterator = this.scopeStack.descendingIterator();
        while (iterator.hasNext()) {
            ScopeData scopeData = iterator.next();
            Map scope = scopeData.scope;
            FinalVariableCandidate candidate = (FinalVariableCandidate)scope.get(ast.getText());
            DetailAST storedVariable = null;
            if (candidate != null) {
                storedVariable = candidate.variableIdent;
            }
            if (storedVariable == null || !FinalLocalVariableCheck.isSameVariables(storedVariable, ast)) continue;
            if (!FinalLocalVariableCheck.shouldRemoveFinalVariableCandidate(scopeData, ast)) break;
            scope.remove(ast.getText());
            break;
        }
    }

    private static boolean isMultipleTypeCatch(DetailAST parameterDefAst) {
        DetailAST typeAst = parameterDefAst.findFirstToken(13);
        return typeAst.getFirstChild().getType() == 112;
    }

    private static boolean shouldRemoveFinalVariableCandidate(ScopeData scopeData, DetailAST ast) {
        boolean shouldRemove = true;
        for (DetailAST variable : scopeData.uninitializedVariables) {
            if (!variable.getText().equals(ast.getText())) continue;
            if (FinalLocalVariableCheck.isInTheSameLoop(variable, ast) || !FinalLocalVariableCheck.isUseOfExternalVariableInsideLoop(ast)) {
                FinalVariableCandidate candidate = (FinalVariableCandidate)scopeData.scope.get(ast.getText());
                shouldRemove = candidate.alreadyAssigned;
            }
            scopeData.uninitializedVariables.remove((Object)variable);
            break;
        }
        return shouldRemove;
    }

    private static boolean isUseOfExternalVariableInsideLoop(DetailAST variable) {
        DetailAST loop2;
        for (loop2 = variable.getParent(); loop2 != null && !FinalLocalVariableCheck.isLoopAst(loop2.getType()); loop2 = loop2.getParent()) {
        }
        return loop2 != null;
    }

    private static boolean isAssignOperator(int parentType) {
        return Arrays.binarySearch(ASSIGN_OPERATOR_TYPES, parentType) >= 0;
    }

    private static boolean isVariableInForInit(DetailAST variableDef) {
        return variableDef.getParent().getType() == 35;
    }

    private static boolean isInAbstractOrNativeMethod(DetailAST ast) {
        boolean abstractOrNative = false;
        for (DetailAST parent = ast.getParent(); parent != null && !abstractOrNative; parent = parent.getParent()) {
            if (parent.getType() != 9) continue;
            DetailAST modifiers = parent.findFirstToken(5);
            abstractOrNative = modifiers.branchContains(40) || modifiers.branchContains(66);
        }
        return abstractOrNative;
    }

    private static boolean isInLambda(DetailAST paramDef) {
        return paramDef.getParent().getParent().getType() == 181;
    }

    private static DetailAST findFirstUpperNamedBlock(DetailAST ast) {
        DetailAST astTraverse = ast;
        while (astTraverse.getType() != 9 && astTraverse.getType() != 14 && astTraverse.getType() != 154 && astTraverse.getType() != 8 && !ScopeUtils.isClassFieldDef(astTraverse)) {
            astTraverse = astTraverse.getParent();
        }
        return astTraverse;
    }

    private static boolean isSameVariables(DetailAST ast1, DetailAST ast2) {
        DetailAST classOrMethodOfAst2;
        DetailAST classOrMethodOfAst1 = FinalLocalVariableCheck.findFirstUpperNamedBlock(ast1);
        return classOrMethodOfAst1 == (classOrMethodOfAst2 = FinalLocalVariableCheck.findFirstUpperNamedBlock(ast2)) && ast1.getText().equals(ast2.getText());
    }

    private static boolean isInTheSameLoop(DetailAST ast1, DetailAST ast2) {
        DetailAST loop2;
        DetailAST loop1;
        for (loop1 = ast1.getParent(); loop1 != null && !FinalLocalVariableCheck.isLoopAst(loop1.getType()); loop1 = loop1.getParent()) {
        }
        for (loop2 = ast2.getParent(); loop2 != null && !FinalLocalVariableCheck.isLoopAst(loop2.getType()); loop2 = loop2.getParent()) {
        }
        return loop1 != null && loop1 == loop2;
    }

    private static boolean isLoopAst(int ast) {
        return Arrays.binarySearch(LOOP_TYPES, ast) >= 0;
    }

    static {
        Arrays.sort(ASSIGN_OPERATOR_TYPES);
        Arrays.sort(LOOP_TYPES);
    }

    private static class FinalVariableCandidate {
        private final DetailAST variableIdent;
        private boolean assigned;
        private boolean alreadyAssigned;

        FinalVariableCandidate(DetailAST variableIdent) {
            this.variableIdent = variableIdent;
        }
    }

    private static class ScopeData {
        private final Map<String, FinalVariableCandidate> scope = new HashMap<String, FinalVariableCandidate>();
        private final Deque<DetailAST> uninitializedVariables = new ArrayDeque<DetailAST>();
        private boolean containsBreak;

        private ScopeData() {
        }

        public Optional<FinalVariableCandidate> findFinalVariableCandidateForAst(DetailAST ast) {
            Optional<FinalVariableCandidate> result = Optional.empty();
            DetailAST storedVariable = null;
            Optional<FinalVariableCandidate> candidate = Optional.ofNullable(this.scope.get(ast.getText()));
            if (candidate.isPresent()) {
                storedVariable = candidate.get().variableIdent;
            }
            if (storedVariable != null && FinalLocalVariableCheck.isSameVariables(storedVariable, ast)) {
                result = candidate;
            }
            return result;
        }
    }
}

