/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import antlr.collections.AST;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;

public class LineWrappingHandler {
    private final IndentationCheck indentCheck;

    public LineWrappingHandler(IndentationCheck instance) {
        this.indentCheck = instance;
    }

    public void checkIndentation(DetailAST firstNode, DetailAST lastNode) {
        this.checkIndentation(firstNode, lastNode, this.indentCheck.getLineWrappingIndentation());
    }

    public void checkIndentation(DetailAST firstNode, DetailAST lastNode, int indentLevel) {
        this.checkIndentation(firstNode, lastNode, indentLevel, -1, true);
    }

    public void checkIndentation(DetailAST firstNode, DetailAST lastNode, int indentLevel, int startIndent, boolean ignoreFirstLine) {
        NavigableMap<Integer, DetailAST> firstNodesOnLines = this.collectFirstNodes(firstNode, lastNode);
        DetailAST firstLineNode = (DetailAST)((Object)firstNodesOnLines.get(firstNodesOnLines.firstKey()));
        if (firstLineNode.getType() == 170) {
            for (DetailAST node = firstLineNode.getParent(); node != null; node = node.getNextSibling()) {
                if (node.getType() != 159) continue;
                DetailAST atNode = node.getFirstChild();
                NavigableMap<Integer, DetailAST> annotationLines = firstNodesOnLines.subMap(node.getLineNo(), true, LineWrappingHandler.getNextNodeLine(firstNodesOnLines, node), true);
                this.checkAnnotationIndentation(atNode, annotationLines, indentLevel);
            }
        }
        if (ignoreFirstLine) {
            firstNodesOnLines.remove(firstNodesOnLines.firstKey());
        }
        int firstNodeIndent = startIndent == -1 ? this.getLineStart(firstLineNode) : startIndent;
        int currentIndent = firstNodeIndent + indentLevel;
        for (DetailAST node : firstNodesOnLines.values()) {
            int currentType = node.getType();
            if (currentType == 77) {
                this.logWarningMessage(node, firstNodeIndent);
                continue;
            }
            if (currentType == 73 || currentType == 29) continue;
            this.logWarningMessage(node, currentIndent);
        }
    }

    private static Integer getNextNodeLine(NavigableMap<Integer, DetailAST> firstNodesOnLines, DetailAST node) {
        Integer nextNodeLine = firstNodesOnLines.higherKey(node.getLastChild().getLineNo());
        if (nextNodeLine == null) {
            nextNodeLine = (Integer)firstNodesOnLines.lastKey();
        }
        return nextNodeLine;
    }

    private NavigableMap<Integer, DetailAST> collectFirstNodes(DetailAST firstNode, DetailAST lastNode) {
        TreeMap<Integer, DetailAST> result = new TreeMap<Integer, DetailAST>();
        result.put(firstNode.getLineNo(), firstNode);
        DetailAST curNode = firstNode.getFirstChild();
        while (curNode != lastNode) {
            DetailAST firstTokenOnLine;
            if (curNode.getType() == 6 || curNode.getType() == 7) {
                curNode = curNode.getLastChild();
            }
            if ((firstTokenOnLine = (DetailAST)((Object)result.get(curNode.getLineNo()))) == null || this.expandedTabsColumnNo(firstTokenOnLine) >= this.expandedTabsColumnNo(curNode)) {
                result.put(curNode.getLineNo(), curNode);
            }
            curNode = LineWrappingHandler.getNextCurNode(curNode);
        }
        return result;
    }

    private static DetailAST getNextCurNode(DetailAST curNode) {
        DetailAST nodeToVisit = curNode.getFirstChild();
        DetailAST currentNode = curNode;
        while (nodeToVisit == null) {
            nodeToVisit = currentNode.getNextSibling();
            if (nodeToVisit != null) continue;
            currentNode = currentNode.getParent();
        }
        return nodeToVisit;
    }

    private void checkAnnotationIndentation(DetailAST atNode, NavigableMap<Integer, DetailAST> firstNodesOnLines, int indentLevel) {
        int firstNodeIndent = this.getLineStart(atNode);
        int currentIndent = firstNodeIndent + indentLevel;
        Collection values = firstNodesOnLines.values();
        DetailAST lastAnnotationNode = atNode.getParent().getLastChild();
        int lastAnnotationLine = lastAnnotationNode.getLineNo();
        Iterator itr = values.iterator();
        while (firstNodesOnLines.size() > 1) {
            boolean isCurrentNodeCloseAnnotationAloneInLine;
            DetailAST node = (DetailAST)((Object)itr.next());
            DetailAST parentNode = node.getParent();
            boolean bl = isCurrentNodeCloseAnnotationAloneInLine = node.getLineNo() == lastAnnotationLine && LineWrappingHandler.isEndOfScope(lastAnnotationNode, node);
            if (isCurrentNodeCloseAnnotationAloneInLine || node.getType() == 170 && (parentNode.getParent().getType() == 5 || parentNode.getParent().getType() == 158)) {
                this.logWarningMessage(node, firstNodeIndent);
            } else {
                this.logWarningMessage(node, currentIndent);
            }
            itr.remove();
        }
    }

    private static boolean isEndOfScope(DetailAST lastAnnotationNode, DetailAST node) {
        DetailAST checkNode = node;
        boolean endOfScope = true;
        block3: while (endOfScope && !checkNode.equals((AST)lastAnnotationNode)) {
            switch (checkNode.getType()) {
                case 48: 
                case 73: {
                    while (checkNode.getNextSibling() == null) {
                        checkNode = checkNode.getParent();
                    }
                    checkNode = checkNode.getNextSibling();
                    continue block3;
                }
            }
            endOfScope = false;
        }
        return endOfScope;
    }

    private int expandedTabsColumnNo(DetailAST ast) {
        String line = this.indentCheck.getLine(ast.getLineNo() - 1);
        return CommonUtils.lengthExpandedTabs(line, ast.getColumnNo(), this.indentCheck.getIndentationTabWidth());
    }

    private int getLineStart(DetailAST ast) {
        String line = this.indentCheck.getLine(ast.getLineNo() - 1);
        return this.getLineStart(line);
    }

    private int getLineStart(String line) {
        int index = 0;
        while (Character.isWhitespace(line.charAt(index))) {
            ++index;
        }
        return CommonUtils.lengthExpandedTabs(line, index, this.indentCheck.getIndentationTabWidth());
    }

    private void logWarningMessage(DetailAST currentNode, int currentIndent) {
        if (this.indentCheck.isForceStrictCondition()) {
            if (this.expandedTabsColumnNo(currentNode) != currentIndent) {
                this.indentCheck.indentationLog(currentNode.getLineNo(), "indentation.error", currentNode.getText(), this.expandedTabsColumnNo(currentNode), currentIndent);
            }
        } else if (this.expandedTabsColumnNo(currentNode) < currentIndent) {
            this.indentCheck.indentationLog(currentNode.getLineNo(), "indentation.error", currentNode.getText(), this.expandedTabsColumnNo(currentNode), currentIndent);
        }
    }
}

