/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.base.CharMatcher;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class SummaryJavadocCheck
extends AbstractJavadocCheck {
    public static final String MSG_SUMMARY_FIRST_SENTENCE = "summary.first.sentence";
    public static final String MSG_SUMMARY_JAVADOC = "summary.javaDoc";
    public static final String MSG_SUMMARY_JAVADOC_MISSING = "summary.javaDoc.missing";
    private static final Pattern JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN = Pattern.compile("\n[ ]+(\\*)|^[ ]+(\\*)");
    private static final String PERIOD = ".";
    private static final String INHERIT_DOC = "{@inheritDoc}";
    private static final Set<Integer> ALLOWED_TYPES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(10074, 4)));
    private Pattern forbiddenSummaryFragments = CommonUtils.createPattern("^$");
    private String period = ".";

    public void setForbiddenSummaryFragments(Pattern pattern) {
        this.forbiddenSummaryFragments = pattern;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        String firstSentence = SummaryJavadocCheck.getFirstSentence(ast);
        int endOfSentence = firstSentence.lastIndexOf(this.period);
        String summaryDoc = SummaryJavadocCheck.getSummarySentence(ast);
        if (summaryDoc.isEmpty()) {
            this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC_MISSING, new Object[0]);
        } else if (!(this.period.isEmpty() || summaryDoc.contains(this.period) || summaryDoc.equals(INHERIT_DOC))) {
            this.log(ast.getLineNumber(), MSG_SUMMARY_FIRST_SENTENCE, new Object[0]);
        }
        if (endOfSentence != -1 && this.containsForbiddenFragment(firstSentence = firstSentence.substring(0, endOfSentence))) {
            this.log(ast.getLineNumber(), MSG_SUMMARY_JAVADOC, new Object[0]);
        }
    }

    private static String getSummarySentence(DetailNode ast) {
        boolean flag = true;
        StringBuilder result = new StringBuilder();
        for (DetailNode child : ast.getChildren()) {
            if (ALLOWED_TYPES.contains(child.getType())) {
                result.append(child.getText());
            } else if (child.getType() == 10072 && SummaryJavadocCheck.getContentOfChild(child).equals(INHERIT_DOC)) {
                result.append(INHERIT_DOC);
            } else if (child.getType() == 10001 && CommonUtils.isBlank(result.toString().trim())) {
                result.append(SummaryJavadocCheck.getStringInsideTag(result.toString(), child.getChildren()[0].getChildren()[0]));
            } else if (child.getType() == 10071) {
                flag = false;
            }
            if (!flag) break;
        }
        return result.toString().trim();
    }

    private static String getContentOfChild(DetailNode child) {
        StringBuilder contents = new StringBuilder();
        for (DetailNode node : child.getChildren()) {
            contents.append(node.getText().trim());
        }
        return contents.toString();
    }

    private static String getStringInsideTag(String result, DetailNode detailNode) {
        StringBuilder contents = new StringBuilder(result);
        DetailNode tempNode = detailNode;
        while (tempNode != null) {
            if (tempNode.getType() == 10074) {
                contents.append(tempNode.getText());
            }
            tempNode = JavadocUtils.getNextSibling(tempNode);
        }
        return contents.toString();
    }

    private static String getFirstSentence(DetailNode ast) {
        StringBuilder result = new StringBuilder();
        String periodSuffix = ". ";
        for (DetailNode child : ast.getChildren()) {
            String text = child.getChildren().length == 0 ? child.getText() : SummaryJavadocCheck.getFirstSentence(child);
            if (child.getType() != 10072 && text.contains(". ")) {
                result.append(text.substring(0, text.indexOf(". ") + 1));
                break;
            }
            result.append(text);
        }
        return result.toString();
    }

    private boolean containsForbiddenFragment(String firstSentence) {
        String javadocText = JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN.matcher(firstSentence).replaceAll(" ");
        javadocText = CharMatcher.whitespace().trimAndCollapseFrom((CharSequence)javadocText, ' ');
        return this.forbiddenSummaryFragments.matcher(javadocText).find();
    }
}

