/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc.utils;

import com.puppycrawl.tools.checkstyle.api.LineColumn;
import com.puppycrawl.tools.checkstyle.checks.javadoc.utils.TagInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InlineTagUtils {
    private static final Pattern INLINE_TAG_PATTERN = Pattern.compile(".*?\\{@(\\p{Alpha}+)\\b(.*?)}", 32);
    private static final Pattern JAVADOC_PREFIX_PATTERN = Pattern.compile("^\\s*\\*", 8);
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\n");
    private static final String LINE_FEED = "\n";
    private static final String CARRIAGE_RETURN = "\r";

    private InlineTagUtils() {
    }

    public static List<TagInfo> extractInlineTags(String ... lines) {
        for (String line : lines) {
            if (!line.contains(LINE_FEED) && !line.contains(CARRIAGE_RETURN)) continue;
            throw new IllegalArgumentException("comment lines cannot contain newlines");
        }
        String commentText = InlineTagUtils.convertLinesToString(lines);
        Matcher inlineTagMatcher = INLINE_TAG_PATTERN.matcher(commentText);
        ArrayList<TagInfo> tags = new ArrayList<TagInfo>();
        while (inlineTagMatcher.find()) {
            String tagName = inlineTagMatcher.group(1);
            String matchedTagValue = inlineTagMatcher.group(2);
            matchedTagValue = InlineTagUtils.removeLeadingJavaDoc(matchedTagValue);
            String tagValue = matchedTagValue = InlineTagUtils.collapseWhitespace(matchedTagValue);
            int startIndex = inlineTagMatcher.start(1);
            LineColumn position = InlineTagUtils.getLineColumnOfIndex(commentText, startIndex - 1);
            tags.add(new TagInfo(tagName, tagValue, position));
        }
        return tags;
    }

    private static String convertLinesToString(String ... lines) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(line);
            builder.append(LINE_FEED);
        }
        return builder.toString();
    }

    private static LineColumn getLineColumnOfIndex(String source, int index) {
        String precedingText = source.subSequence(0, index).toString();
        String[] precedingLines = NEWLINE_PATTERN.split(precedingText);
        String lastLine = precedingLines[precedingLines.length - 1];
        return new LineColumn(precedingLines.length, lastLine.length());
    }

    private static String collapseWhitespace(String str) {
        Matcher matcher = WHITESPACE_PATTERN.matcher(str);
        return matcher.replaceAll(" ").trim();
    }

    private static String removeLeadingJavaDoc(String source) {
        Matcher matcher = JAVADOC_PREFIX_PATTERN.matcher(source);
        return matcher.replaceAll("");
    }
}

