/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;

public class GenericWhitespaceCheck
extends AbstractCheck {
    public static final String MSG_WS_PRECEDED = "ws.preceded";
    public static final String MSG_WS_FOLLOWED = "ws.followed";
    public static final String MSG_WS_NOT_PRECEDED = "ws.notPreceded";
    public static final String MSG_WS_ILLEGAL_FOLLOW = "ws.illegalFollow";
    private static final String OPEN_ANGLE_BRACKET = "<";
    private static final String CLOSE_ANGLE_BRACKET = ">";
    private int depth;

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{172, 173};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.depth = 0;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 172: {
                this.processStart(ast);
                ++this.depth;
                break;
            }
            case 173: {
                this.processEnd(ast);
                --this.depth;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)ast));
            }
        }
    }

    private void processEnd(DetailAST ast) {
        String line = this.getLine(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        int after = ast.getColumnNo() + 1;
        if (before >= 0 && Character.isWhitespace(line.charAt(before)) && !CommonUtils.hasWhitespaceBefore(before, line)) {
            this.log(ast.getLineNo(), before, MSG_WS_PRECEDED, CLOSE_ANGLE_BRACKET);
        }
        if (after < line.length()) {
            if (this.depth == 1) {
                this.processSingleGeneric(ast, line, after);
            } else {
                this.processNestedGenerics(ast, line, after);
            }
        }
    }

    private void processNestedGenerics(DetailAST ast, String line, int after) {
        int indexOfAmp = line.indexOf(38, after);
        if (indexOfAmp >= 0 && GenericWhitespaceCheck.containsWhitespaceBetween(after, indexOfAmp, line)) {
            if (indexOfAmp - after == 0) {
                this.log(ast.getLineNo(), after, MSG_WS_NOT_PRECEDED, "&");
            } else if (indexOfAmp - after != 1) {
                this.log(ast.getLineNo(), after, MSG_WS_FOLLOWED, CLOSE_ANGLE_BRACKET);
            }
        } else if (line.charAt(after) == ' ') {
            this.log(ast.getLineNo(), after, MSG_WS_FOLLOWED, CLOSE_ANGLE_BRACKET);
        }
    }

    private void processSingleGeneric(DetailAST ast, String line, int after) {
        char charAfter = line.charAt(after);
        if (GenericWhitespaceCheck.isGenericBeforeMethod(ast)) {
            if (Character.isWhitespace(charAfter)) {
                this.log(ast.getLineNo(), after, MSG_WS_FOLLOWED, CLOSE_ANGLE_BRACKET);
            }
        } else if (!GenericWhitespaceCheck.isCharacterValidAfterGenericEnd(charAfter)) {
            this.log(ast.getLineNo(), after, MSG_WS_ILLEGAL_FOLLOW, CLOSE_ANGLE_BRACKET);
        }
    }

    private static boolean isGenericBeforeMethod(DetailAST ast) {
        return ast.getParent().getType() == 163 && ast.getParent().getParent().getType() == 59 && ast.getParent().getParent().getParent().getType() == 27 || GenericWhitespaceCheck.isAfterMethodReference(ast);
    }

    private static boolean isAfterMethodReference(DetailAST genericEnd) {
        return genericEnd.getParent().getParent().getType() == 180;
    }

    private void processStart(DetailAST ast) {
        String line = this.getLine(ast.getLineNo() - 1);
        int before = ast.getColumnNo() - 1;
        int after = ast.getColumnNo() + 1;
        if (before >= 0) {
            DetailAST parent = ast.getParent();
            DetailAST grandparent = parent.getParent();
            if (parent.getType() == 165 && (grandparent.getType() == 8 || grandparent.getType() == 9)) {
                if (!Character.isWhitespace(line.charAt(before))) {
                    this.log(ast.getLineNo(), before, MSG_WS_NOT_PRECEDED, OPEN_ANGLE_BRACKET);
                }
            } else if (Character.isWhitespace(line.charAt(before)) && !CommonUtils.hasWhitespaceBefore(before, line)) {
                this.log(ast.getLineNo(), before, MSG_WS_PRECEDED, OPEN_ANGLE_BRACKET);
            }
        }
        if (after < line.length() && Character.isWhitespace(line.charAt(after))) {
            this.log(ast.getLineNo(), after, MSG_WS_FOLLOWED, OPEN_ANGLE_BRACKET);
        }
    }

    private static boolean containsWhitespaceBetween(int fromIndex, int toIndex, String line) {
        boolean result = true;
        for (int i = fromIndex; i < toIndex; ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            result = false;
            break;
        }
        return result;
    }

    private static boolean isCharacterValidAfterGenericEnd(char charAfter) {
        return charAfter == '(' || charAfter == ')' || charAfter == ',' || charAfter == '[' || charAfter == '.' || charAfter == ':' || charAfter == ';' || Character.isWhitespace(charAfter);
    }
}

