/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.ThreadModeSettings;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DefaultConfiguration
implements Configuration {
    private static final long serialVersionUID = 1157875385356127169L;
    private final String name;
    private final List<Configuration> children = new ArrayList<Configuration>();
    private final Map<String, String> attributeMap = new HashMap<String, String>();
    private final Map<String, String> messages = new HashMap<String, String>();
    private final ThreadModeSettings threadModeSettings;

    public DefaultConfiguration(String name) {
        this(name, ThreadModeSettings.SINGLE_THREAD_MODE_INSTANCE);
    }

    public DefaultConfiguration(String name, ThreadModeSettings threadModeSettings) {
        this.name = name;
        this.threadModeSettings = threadModeSettings;
    }

    @Override
    public String[] getAttributeNames() {
        Set<String> keySet = this.attributeMap.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    @Override
    public String getAttribute(String attributeName) throws CheckstyleException {
        if (!this.attributeMap.containsKey(attributeName)) {
            throw new CheckstyleException("missing key '" + attributeName + "' in " + this.name);
        }
        return this.attributeMap.get(attributeName);
    }

    @Override
    public Configuration[] getChildren() {
        return this.children.toArray(new Configuration[this.children.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addChild(Configuration configuration) {
        this.children.add(configuration);
    }

    public void removeChild(Configuration configuration) {
        this.children.remove(configuration);
    }

    public void addAttribute(String attributeName, String value) {
        String current = this.attributeMap.get(attributeName);
        if (current == null) {
            this.attributeMap.put(attributeName, value);
        } else {
            this.attributeMap.put(attributeName, current + "," + value);
        }
    }

    public void addMessage(String key, String value) {
        this.messages.put(key, value);
    }

    @Override
    public Map<String, String> getMessages() {
        return new HashMap<String, String>(this.messages);
    }

    public ThreadModeSettings getThreadModeSettings() {
        return this.threadModeSettings;
    }
}

