/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.google.common.reflect.ClassPath;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.AutomaticBean;
import com.puppycrawl.tools.checkstyle.api.BeforeExecutionFileFilter;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.api.RootModule;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public final class ModuleReflectionUtils {
    private ModuleReflectionUtils() {
    }

    public static Set<Class<?>> getCheckstyleModules(Collection<String> packages, ClassLoader loader) throws IOException {
        ClassPath classPath = ClassPath.from((ClassLoader)loader);
        return packages.stream().flatMap(pkg -> classPath.getTopLevelClasses(pkg).stream()).map(ClassPath.ClassInfo::load).filter(ModuleReflectionUtils::isCheckstyleModule).collect(Collectors.toSet());
    }

    public static boolean isCheckstyleModule(Class<?> clazz) {
        return ModuleReflectionUtils.isValidCheckstyleClass(clazz) && (ModuleReflectionUtils.isCheckstyleTreeWalkerCheck(clazz) || ModuleReflectionUtils.isFileSetModule(clazz) || ModuleReflectionUtils.isFilterModule(clazz) || ModuleReflectionUtils.isFileFilterModule(clazz) || ModuleReflectionUtils.isTreeWalkerFilterModule(clazz) || ModuleReflectionUtils.isAuditListener(clazz) || ModuleReflectionUtils.isRootModule(clazz));
    }

    public static boolean isValidCheckstyleClass(Class<?> clazz) {
        return AutomaticBean.class.isAssignableFrom(clazz) && !Modifier.isAbstract(clazz.getModifiers()) && ModuleReflectionUtils.hasDefaultConstructor(clazz);
    }

    private static boolean hasDefaultConstructor(Class<?> clazz) {
        boolean result = false;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isCheckstyleTreeWalkerCheck(Class<?> clazz) {
        return AbstractCheck.class.isAssignableFrom(clazz);
    }

    public static boolean isFileSetModule(Class<?> clazz) {
        return AbstractFileSetCheck.class.isAssignableFrom(clazz);
    }

    public static boolean isFilterModule(Class<?> clazz) {
        return Filter.class.isAssignableFrom(clazz);
    }

    public static boolean isFileFilterModule(Class<?> clazz) {
        return BeforeExecutionFileFilter.class.isAssignableFrom(clazz);
    }

    public static boolean isAuditListener(Class<?> clazz) {
        return AuditListener.class.isAssignableFrom(clazz);
    }

    public static boolean isRootModule(Class<?> clazz) {
        return RootModule.class.isAssignableFrom(clazz);
    }

    public static boolean isTreeWalkerFilterModule(Class<?> clazz) {
        return TreeWalkerFilter.class.isAssignableFrom(clazz);
    }
}

