/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.io.File;
import java.util.regex.Pattern;

@FileStatefulCheck
public class OuterTypeFilenameCheck
extends AbstractCheck {
    public static final String MSG_KEY = "type.file.mismatch";
    private static final Pattern FILE_EXTENSION_PATTERN = Pattern.compile("\\.[^.]*$");
    private boolean seenFirstToken;
    private String fileName;
    private boolean hasPublic;
    private boolean validFirst;
    private DetailAST wrongType;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{14, 15, 154, 157};
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.fileName = this.getFileName();
        this.seenFirstToken = false;
        this.validFirst = false;
        this.hasPublic = false;
        this.wrongType = null;
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (this.seenFirstToken) {
            DetailAST modifiers = ast.findFirstToken(5);
            if (modifiers.findFirstToken(62) != null && ast.getParent() == null) {
                this.hasPublic = true;
            }
        } else {
            String outerTypeName = ast.findFirstToken(58).getText();
            if (this.fileName.equals(outerTypeName)) {
                this.validFirst = true;
            } else {
                this.wrongType = ast;
            }
        }
        this.seenFirstToken = true;
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        if (!this.validFirst && !this.hasPublic && this.wrongType != null) {
            this.log(this.wrongType.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private String getFileName() {
        String name = this.getFileContents().getFileName();
        name = name.substring(name.lastIndexOf(File.separatorChar) + 1);
        name = FILE_EXTENSION_PATTERN.matcher(name).replaceAll("");
        return name;
    }
}

