/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.naming.AbstractNameCheck;

public abstract class AbstractAccessControlNameCheck
extends AbstractNameCheck {
    private boolean applyToPublic = true;
    private boolean applyToProtected = true;
    private boolean applyToPackage = true;
    private boolean applyToPrivate = true;

    protected AbstractAccessControlNameCheck(String format) {
        super(format);
    }

    @Override
    protected boolean mustCheckName(DetailAST ast) {
        return this.shouldCheckInScope(ast.findFirstToken(5));
    }

    protected boolean shouldCheckInScope(DetailAST modifiers) {
        boolean isPublic = modifiers.findFirstToken(62) != null;
        boolean isProtected = modifiers.findFirstToken(63) != null;
        boolean isPrivate = modifiers.findFirstToken(61) != null;
        boolean isPackage = !isPublic && !isProtected && !isPrivate;
        return this.applyToPublic && isPublic || this.applyToProtected && isProtected || this.applyToPackage && isPackage || this.applyToPrivate && isPrivate;
    }

    public void setApplyToPublic(boolean applyTo) {
        this.applyToPublic = applyTo;
    }

    public void setApplyToProtected(boolean applyTo) {
        this.applyToProtected = applyTo;
    }

    public void setApplyToPackage(boolean applyTo) {
        this.applyToPackage = applyTo;
    }

    public void setApplyToPrivate(boolean applyTo) {
        this.applyToPrivate = applyTo;
    }
}

