/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XmlLoader
extends DefaultHandler {
    private final Map<String, String> publicIdToResourceNameMap;
    private final XMLReader parser;

    protected XmlLoader(Map<String, String> publicIdToResourceNameMap) throws SAXException, ParserConfigurationException {
        this.publicIdToResourceNameMap = new HashMap<String, String>(publicIdToResourceNameMap);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        LoadExternalDtdFeatureProvider.setFeaturesBySystemProperty(factory);
        factory.setValidating(true);
        this.parser = factory.newSAXParser().getXMLReader();
        this.parser.setContentHandler(this);
        this.parser.setEntityResolver(this);
        this.parser.setErrorHandler(this);
    }

    public void parseInputSource(InputSource inputSource) throws IOException, SAXException {
        this.parser.parse(inputSource);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource;
        if (this.publicIdToResourceNameMap.keySet().contains(publicId)) {
            String dtdResourceName = this.publicIdToResourceNameMap.get(publicId);
            ClassLoader loader = this.getClass().getClassLoader();
            InputStream dtdIs = loader.getResourceAsStream(dtdResourceName);
            inputSource = new InputSource(dtdIs);
        } else {
            inputSource = super.resolveEntity(publicId, systemId);
        }
        return inputSource;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public static final class LoadExternalDtdFeatureProvider {
        public static final String ENABLE_EXTERNAL_DTD_LOAD = "checkstyle.enableExternalDtdLoad";
        private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";

        private LoadExternalDtdFeatureProvider() {
        }

        public static void setFeaturesBySystemProperty(SAXParserFactory factory) throws SAXException, ParserConfigurationException {
            boolean enableExternalDtdLoad = Boolean.valueOf(System.getProperty(ENABLE_EXTERNAL_DTD_LOAD, "false"));
            factory.setFeature(LOAD_EXTERNAL_DTD, enableExternalDtdLoad);
            factory.setFeature(EXTERNAL_GENERAL_ENTITIES, enableExternalDtdLoad);
        }
    }
}

