/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public class RegexpOnFilenameCheck
extends AbstractFileSetCheck {
    public static final String MSG_MATCH = "regexp.filename.match";
    public static final String MSG_MISMATCH = "regexp.filename.mismatch";
    private Pattern folderPattern;
    private Pattern fileNamePattern;
    private boolean match = true;
    private boolean ignoreFileNameExtensions;

    public void setFolderPattern(Pattern folderPattern) {
        this.folderPattern = folderPattern;
    }

    public void setFileNamePattern(Pattern fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
    }

    public void setMatch(boolean match) {
        this.match = match;
    }

    public void setIgnoreFileNameExtensions(boolean ignoreFileNameExtensions) {
        this.ignoreFileNameExtensions = ignoreFileNameExtensions;
    }

    @Override
    public void init() {
        if (this.fileNamePattern == null && this.folderPattern == null) {
            this.fileNamePattern = CommonUtils.createPattern("\\s");
        }
    }

    @Override
    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        String fileName = this.getFileName(file);
        String folderPath = RegexpOnFilenameCheck.getFolderPath(file);
        if (this.isMatchFolder(folderPath) && this.isMatchFile(fileName)) {
            this.log();
        }
    }

    private String getFileName(File file) {
        String fileName = file.getName();
        if (this.ignoreFileNameExtensions) {
            fileName = CommonUtils.getFileNameWithoutExtension(fileName);
        }
        return fileName;
    }

    private static String getFolderPath(File file) throws CheckstyleException {
        try {
            return file.getParentFile().getCanonicalPath();
        }
        catch (IOException ex) {
            throw new CheckstyleException("unable to create canonical path names for " + file.getAbsolutePath(), ex);
        }
    }

    private boolean isMatchFolder(String folderPath) {
        boolean result;
        if (this.folderPattern == null) {
            result = true;
        } else {
            boolean useMatch = this.fileNamePattern != null || this.match;
            result = this.folderPattern.matcher(folderPath).find() == useMatch;
        }
        return result;
    }

    private boolean isMatchFile(String fileName) {
        return this.fileNamePattern == null || this.fileNamePattern.matcher(fileName).find() == this.match;
    }

    private void log() {
        String folder = RegexpOnFilenameCheck.getStringOrDefault(this.folderPattern, "");
        String fileName = RegexpOnFilenameCheck.getStringOrDefault(this.fileNamePattern, "");
        if (this.match) {
            this.log(0, MSG_MATCH, folder, fileName);
        } else {
            this.log(0, MSG_MISMATCH, folder, fileName);
        }
    }

    private static String getStringOrDefault(Pattern pattern, String defaultString) {
        String result = pattern == null ? defaultString : pattern.toString();
        return result;
    }
}

