/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Optional;

@StatelessCheck
public class NeedBracesCheck
extends AbstractCheck {
    public static final String MSG_KEY_NEED_BRACES = "needBraces";
    private boolean allowSingleLineStatement;
    private boolean allowEmptyLoopBody;

    public void setAllowSingleLineStatement(boolean allowSingleLineStatement) {
        this.allowSingleLineStatement = allowSingleLineStatement;
    }

    public void setAllowEmptyLoopBody(boolean allowEmptyLoopBody) {
        this.allowEmptyLoopBody = allowEmptyLoopBody;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{85, 92, 91, 83, 84};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{85, 92, 91, 83, 84, 93, 94, 181};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean hasNoSlist;
        boolean bl = hasNoSlist = ast.findFirstToken(7) == null;
        if (hasNoSlist && !this.isSkipStatement(ast) && this.isBracesNeeded(ast)) {
            this.log(ast.getLineNo(), MSG_KEY_NEED_BRACES, ast.getText());
        }
    }

    private boolean isBracesNeeded(DetailAST ast) {
        boolean result;
        switch (ast.getType()) {
            case 84: 
            case 91: {
                result = !this.isEmptyLoopBodyAllowed(ast);
                break;
            }
            case 93: 
            case 94: {
                result = NeedBracesCheck.hasUnbracedStatements(ast);
                break;
            }
            case 92: {
                result = ast.findFirstToken(83) == null;
                break;
            }
            default: {
                result = true;
            }
        }
        return result;
    }

    private boolean isEmptyLoopBodyAllowed(DetailAST ast) {
        return this.allowEmptyLoopBody && ast.findFirstToken(38) != null;
    }

    private static boolean hasUnbracedStatements(DetailAST ast) {
        DetailAST nextSibling = ast.getNextSibling();
        return nextSibling != null && nextSibling.getType() == 7 && nextSibling.getFirstChild().getType() != 7;
    }

    private boolean isSkipStatement(DetailAST statement) {
        return this.allowSingleLineStatement && NeedBracesCheck.isSingleLineStatement(statement);
    }

    private static boolean isSingleLineStatement(DetailAST statement) {
        boolean result;
        switch (statement.getType()) {
            case 83: {
                result = NeedBracesCheck.isSingleLineIf(statement);
                break;
            }
            case 91: {
                result = NeedBracesCheck.isSingleLineFor(statement);
                break;
            }
            case 85: {
                result = NeedBracesCheck.isSingleLineDoWhile(statement);
                break;
            }
            case 84: {
                result = NeedBracesCheck.isSingleLineWhile(statement);
                break;
            }
            case 181: {
                result = NeedBracesCheck.isSingleLineLambda(statement);
                break;
            }
            case 93: 
            case 94: {
                result = NeedBracesCheck.isSingleLineSwitchMember(statement);
                break;
            }
            default: {
                result = NeedBracesCheck.isSingleLineElse(statement);
            }
        }
        return result;
    }

    private static boolean isSingleLineWhile(DetailAST literalWhile) {
        boolean result = false;
        if (literalWhile.getParent().getType() == 7) {
            DetailAST block = literalWhile.getLastChild().getPreviousSibling();
            result = TokenUtil.areOnSameLine(literalWhile, block);
        }
        return result;
    }

    private static boolean isSingleLineDoWhile(DetailAST literalDo) {
        boolean result = false;
        if (literalDo.getParent().getType() == 7) {
            DetailAST block = literalDo.getFirstChild();
            result = TokenUtil.areOnSameLine(block, literalDo);
        }
        return result;
    }

    private static boolean isSingleLineFor(DetailAST literalFor) {
        boolean result = false;
        if (literalFor.getLastChild().getType() == 38) {
            result = true;
        } else if (literalFor.getParent().getType() == 7) {
            result = TokenUtil.areOnSameLine(literalFor, literalFor.getLastChild());
        }
        return result;
    }

    private static boolean isSingleLineIf(DetailAST literalIf) {
        boolean result = false;
        if (literalIf.getParent().getType() == 7) {
            DetailAST literalIfLastChild = literalIf.getLastChild();
            DetailAST block = literalIfLastChild.getType() == 92 ? literalIfLastChild.getPreviousSibling() : literalIfLastChild;
            DetailAST ifCondition = literalIf.findFirstToken(28);
            result = TokenUtil.areOnSameLine(ifCondition, block);
        }
        return result;
    }

    private static boolean isSingleLineLambda(DetailAST lambda) {
        DetailAST lastLambdaToken = NeedBracesCheck.getLastLambdaToken(lambda);
        return TokenUtil.areOnSameLine(lambda, lastLambdaToken);
    }

    private static DetailAST getLastLambdaToken(DetailAST lambda) {
        DetailAST node = lambda;
        while ((node = node.getLastChild()).getLastChild() != null) {
        }
        return node;
    }

    private static boolean isSingleLineSwitchMember(DetailAST ast) {
        return Optional.of(ast).map(DetailAST::getNextSibling).map(DetailAST::getLastChild).map(lastToken -> TokenUtil.areOnSameLine(ast, lastToken)).orElse(true);
    }

    private static boolean isSingleLineElse(DetailAST literalElse) {
        DetailAST block = literalElse.getFirstChild();
        return TokenUtil.areOnSameLine(literalElse, block);
    }
}

