/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.design;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@FileStatefulCheck
public class OneTopLevelClassCheck
extends AbstractCheck {
    public static final String MSG_KEY = "one.top.level.class";
    private static final Comparator<DetailAST> LINE_AND_COL_COMPARATOR = Comparator.comparingInt(DetailAST::getLineNo).thenComparingInt(DetailAST::getColumnNo);
    private boolean publicTypeFound;
    private final SortedMap<DetailAST, String> lineNumberTypeMap = new TreeMap<DetailAST, String>(LINE_AND_COL_COMPARATOR);

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.publicTypeFound = false;
        this.lineNumberTypeMap.clear();
        for (DetailAST currentNode = rootAST; currentNode != null; currentNode = currentNode.getNextSibling()) {
            if (currentNode.getType() != 14 && currentNode.getType() != 154 && currentNode.getType() != 15) continue;
            if (OneTopLevelClassCheck.isPublic(currentNode)) {
                this.publicTypeFound = true;
                continue;
            }
            String typeName = currentNode.findFirstToken(58).getText();
            this.lineNumberTypeMap.put(currentNode, typeName);
        }
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        if (!this.lineNumberTypeMap.isEmpty()) {
            if (!this.publicTypeFound) {
                this.lineNumberTypeMap.remove(this.lineNumberTypeMap.firstKey());
            }
            for (Map.Entry<DetailAST, String> entry : this.lineNumberTypeMap.entrySet()) {
                this.log(entry.getKey(), MSG_KEY, entry.getValue());
            }
        }
    }

    private static boolean isPublic(DetailAST typeDef) {
        DetailAST modifiers = typeDef.findFirstToken(5);
        return modifiers.findFirstToken(62) != null;
    }
}

