/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class AvoidStaticImportCheck
extends AbstractCheck {
    public static final String MSG_KEY = "import.avoidStatic";
    private String[] excludes = CommonUtil.EMPTY_STRING_ARRAY;

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{152};
    }

    public void setExcludes(String ... excludes) {
        this.excludes = (String[])excludes.clone();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST startingDot = ast.getFirstChild().getNextSibling();
        FullIdent name = FullIdent.createFullIdent(startingDot);
        if (!this.isExempt(name.getText())) {
            this.log(startingDot, MSG_KEY, name.getText());
        }
    }

    private boolean isExempt(String classOrStaticMember) {
        boolean exempt = false;
        for (String exclude : this.excludes) {
            if (!classOrStaticMember.equals(exclude) && !AvoidStaticImportCheck.isStarImportOfPackage(classOrStaticMember, exclude)) continue;
            exempt = true;
            break;
        }
        return exempt;
    }

    private static boolean isStarImportOfPackage(String classOrStaticMember, String exclude) {
        String member;
        String excludeMinusDotStar;
        boolean result = false;
        if (exclude.endsWith(".*") && classOrStaticMember.startsWith(excludeMinusDotStar = exclude.substring(0, exclude.length() - 2)) && !classOrStaticMember.equals(excludeMinusDotStar) && (member = classOrStaticMember.substring(excludeMinusDotStar.length() + 1)).indexOf(46) == -1) {
            result = true;
        }
        return result;
    }
}

