/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodCallHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.NewHandler;

public class LambdaHandler
extends AbstractExpressionHandler {
    public LambdaHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "lambda", ast, parent);
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        return this.getIndent();
    }

    @Override
    protected IndentLevel getIndentImpl() {
        if (this.getParent() instanceof MethodCallHandler) {
            return this.getParent().getSuggestedChildIndent(this);
        }
        DetailAST parent = this.getMainAst().getParent();
        if (this.getParent() instanceof NewHandler) {
            parent = parent.getParent();
        }
        IndentLevel level = new IndentLevel(this.getLineStart(parent));
        DetailAST firstChild = this.getMainAst().getFirstChild();
        if (this.getLineStart(firstChild) == this.expandedTabsColumnNo(firstChild)) {
            level = new IndentLevel(level, this.getIndentCheck().getLineWrappingIndentation());
        }
        return level;
    }

    @Override
    public void checkIndentation() {
        IndentLevel level;
        DetailAST firstChild = this.getMainAst().getFirstChild();
        if (this.getLineStart(firstChild) == this.expandedTabsColumnNo(firstChild) && !(level = this.getIndent()).isAcceptable(this.expandedTabsColumnNo(firstChild))) {
            this.logError(firstChild, "arguments", this.expandedTabsColumnNo(firstChild), level);
        }
        if (this.getLineStart(this.getMainAst()) == this.expandedTabsColumnNo(this.getMainAst()) && !(level = new IndentLevel(this.getIndent(), this.getIndentCheck().getLineWrappingIndentation())).isAcceptable(this.expandedTabsColumnNo(this.getMainAst()))) {
            this.logError(this.getMainAst(), "", this.expandedTabsColumnNo(this.getMainAst()), level);
        }
    }
}

