/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

public class NewHandler
extends AbstractExpressionHandler {
    private final DetailAST mainAst;

    public NewHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "operator new", ast, parent);
        this.mainAst = ast;
    }

    @Override
    public void checkIndentation() {
        DetailAST firstChild;
        IndentLevel level;
        int columnNo;
        if (this.isOnStartOfLine(this.mainAst) && !this.isNewKeywordFollowedByAssign() && (columnNo = this.expandedTabsColumnNo(this.mainAst)) < (level = this.getIndentImpl()).getFirstIndentLevel()) {
            this.logError(this.mainAst, "", columnNo, level);
        }
        if ((firstChild = this.mainAst.getFirstChild()) != null) {
            this.checkExpressionSubtree(firstChild, this.getIndent(), false, false);
        }
        DetailAST lparen = this.mainAst.findFirstToken(76);
        this.checkLeftParen(lparen);
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        int offset = TokenUtil.isOfType(child.getMainAst(), 6) ? this.getBasicOffset() : this.getLineWrappingIndent();
        return new IndentLevel(this.getIndent(), offset);
    }

    @Override
    protected IndentLevel getIndentImpl() {
        IndentLevel result;
        if (this.getLineStart(this.mainAst) == this.mainAst.getColumnNo()) {
            result = super.getIndentImpl();
            if (this.isNewKeywordFollowedByAssign()) {
                result = new IndentLevel(result, this.getLineWrappingIndent());
            }
        } else {
            result = new IndentLevel(this.getLineStart(this.mainAst));
        }
        return result;
    }

    private boolean isNewKeywordFollowedByAssign() {
        return this.mainAst.getParent().getParent().getType() == 80;
    }

    private int getLineWrappingIndent() {
        return this.getIndentCheck().getLineWrappingIndentation();
    }

    @Override
    protected boolean shouldIncreaseIndent() {
        return false;
    }
}

