/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;

@StatelessCheck
public class InnerAssignmentCheck
extends AbstractCheck {
    public static final String MSG_KEY = "assignment.inner.avoid";
    private static final int[][] ALLOWED_ASSIGNMENT_CONTEXT = new int[][]{{28, 7}, {10}, {28, 34, 35}, {28, 34, 37}, {160}, {178, 177, 176}, {28, 181}};
    private static final int[][] CONTROL_CONTEXT = new int[][]{{28, 85}, {28, 91}, {28, 84}, {28, 83}, {28, 92}};
    private static final int[][] ALLOWED_ASSIGNMENT_IN_COMPARISON_CONTEXT = new int[][]{{28, 84}, {28, 36}, {28, 85}};
    private static final int[] COMPARISON_TYPES = new int[]{116, 120, 118, 119, 117, 115};
    private static final int[] LOOP_IDIOM_IGNORED_PARENTS = new int[]{111, 110, 132, 112, 114};

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{80, 101, 98, 99, 100, 102, 103, 104, 105, 107, 108, 106};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (!(InnerAssignmentCheck.isInContext(ast, ALLOWED_ASSIGNMENT_CONTEXT, new int[0]) || InnerAssignmentCheck.isInNoBraceControlStatement(ast) || InnerAssignmentCheck.isInLoopIdiom(ast))) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private static boolean isInNoBraceControlStatement(DetailAST ast) {
        boolean result = false;
        if (InnerAssignmentCheck.isInContext(ast, CONTROL_CONTEXT, new int[0])) {
            DetailAST expr = ast.getParent();
            DetailAST exprNext = expr.getNextSibling();
            result = exprNext.getType() == 45;
        }
        return result;
    }

    private static boolean isInLoopIdiom(DetailAST ast) {
        boolean result = false;
        if (InnerAssignmentCheck.isComparison(ast.getParent())) {
            result = InnerAssignmentCheck.isInContext(ast.getParent(), ALLOWED_ASSIGNMENT_IN_COMPARISON_CONTEXT, LOOP_IDIOM_IGNORED_PARENTS);
        }
        return result;
    }

    private static boolean isComparison(DetailAST ast) {
        int astType = ast.getType();
        return Arrays.binarySearch(COMPARISON_TYPES, astType) >= 0;
    }

    private static boolean isInContext(DetailAST ast, int[][] contextSet, int ... skipTokens) {
        boolean found = false;
        for (int[] element : contextSet) {
            DetailAST current = ast;
            for (int anElement : element) {
                if ((current = InnerAssignmentCheck.getParent(current, skipTokens)).getType() != anElement) {
                    found = false;
                    break;
                }
                found = true;
            }
            if (found) break;
        }
        return found;
    }

    private static DetailAST getParent(DetailAST ast, int ... skipTokens) {
        DetailAST result = ast.getParent();
        while (Arrays.binarySearch(skipTokens, result.getType()) > -1) {
            result = result.getParent();
        }
        return result;
    }

    static {
        Arrays.sort(COMPARISON_TYPES);
        Arrays.sort(LOOP_IDIOM_IGNORED_PARENTS);
    }
}

