/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.DetailNodeTreeStringPrinter;
import com.puppycrawl.tools.checkstyle.JavaParser;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public final class AstTreeStringPrinter {
    private static final Pattern NEWLINE = Pattern.compile("\n");
    private static final Pattern RETURN = Pattern.compile("\r");
    private static final Pattern TAB = Pattern.compile("\t");
    private static final String LINE_SEPARATOR = System.lineSeparator();

    private AstTreeStringPrinter() {
    }

    public static String printFileAst(File file, JavaParser.Options options) throws IOException, CheckstyleException {
        return AstTreeStringPrinter.printTree(JavaParser.parseFile(file, options));
    }

    public static String printJavaAndJavadocTree(File file) throws IOException, CheckstyleException {
        DetailAST tree = JavaParser.parseFile(file, JavaParser.Options.WITH_COMMENTS);
        return AstTreeStringPrinter.printJavaAndJavadocTree(tree);
    }

    private static String printJavaAndJavadocTree(DetailAST ast) {
        StringBuilder messageBuilder = new StringBuilder(1024);
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            messageBuilder.append(AstTreeStringPrinter.getIndentation(node)).append(AstTreeStringPrinter.getNodeInfo(node)).append(LINE_SEPARATOR);
            if (node.getType() == 183 && JavadocUtil.isJavadocComment(node.getParent())) {
                String javadocTree = AstTreeStringPrinter.parseAndPrintJavadocTree(node);
                messageBuilder.append(javadocTree);
                continue;
            }
            messageBuilder.append(AstTreeStringPrinter.printJavaAndJavadocTree(node.getFirstChild()));
        }
        return messageBuilder.toString();
    }

    private static String parseAndPrintJavadocTree(DetailAST node) {
        DetailAST javadocBlock = node.getParent();
        DetailNode tree = DetailNodeTreeStringPrinter.parseJavadocAsDetailNode(javadocBlock);
        String baseIndentation = AstTreeStringPrinter.getIndentation(node);
        baseIndentation = baseIndentation.substring(0, baseIndentation.length() - 2);
        String rootPrefix = baseIndentation + "   `--";
        String prefix = baseIndentation + "       ";
        return DetailNodeTreeStringPrinter.printTree(tree, rootPrefix, prefix);
    }

    public static String printAst(FileText text, JavaParser.Options options) throws CheckstyleException {
        DetailAST ast = JavaParser.parseFileText(text, options);
        return AstTreeStringPrinter.printTree(ast);
    }

    public static String printBranch(DetailAST node) {
        String result = node == null ? "" : AstTreeStringPrinter.printBranch(node.getParent()) + AstTreeStringPrinter.getIndentation(node) + AstTreeStringPrinter.getNodeInfo(node) + LINE_SEPARATOR;
        return result;
    }

    private static String printTree(DetailAST ast) {
        StringBuilder messageBuilder = new StringBuilder(1024);
        for (DetailAST node = ast; node != null; node = node.getNextSibling()) {
            messageBuilder.append(AstTreeStringPrinter.getIndentation(node)).append(AstTreeStringPrinter.getNodeInfo(node)).append(LINE_SEPARATOR).append(AstTreeStringPrinter.printTree(node.getFirstChild()));
        }
        return messageBuilder.toString();
    }

    private static String getNodeInfo(DetailAST node) {
        return TokenUtil.getTokenName(node.getType()) + " -> " + AstTreeStringPrinter.escapeAllControlChars(node.getText()) + " [" + node.getLineNo() + ':' + node.getColumnNo() + ']';
    }

    private static String getIndentation(DetailAST ast) {
        boolean isLastChild = ast.getNextSibling() == null;
        DetailAST node = ast;
        StringBuilder indentation = new StringBuilder(1024);
        while (node.getParent() != null) {
            if ((node = node.getParent()).getParent() == null) {
                if (isLastChild) {
                    indentation.append("`--");
                    continue;
                }
                indentation.append("|--");
                continue;
            }
            if (node.getNextSibling() == null) {
                indentation.insert(0, "    ");
                continue;
            }
            indentation.insert(0, "|   ");
        }
        return indentation.toString();
    }

    private static String escapeAllControlChars(String text) {
        String textWithoutNewlines = NEWLINE.matcher(text).replaceAll("\\\\n");
        String textWithoutReturns = RETURN.matcher(textWithoutNewlines).replaceAll("\\\\r");
        return TAB.matcher(textWithoutReturns).replaceAll("\\\\t");
    }
}

