/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.naming;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.regex.Pattern;

@StatelessCheck
public abstract class AbstractNameCheck
extends AbstractCheck {
    public static final String MSG_INVALID_PATTERN = "name.invalidPattern";
    private Pattern format;

    protected AbstractNameCheck(String format) {
        this.format = CommonUtils.createPattern(format);
    }

    protected abstract boolean mustCheckName(DetailAST var1);

    public final void setFormat(Pattern pattern) {
        this.format = pattern;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST nameAST;
        if (this.mustCheckName(ast) && !this.format.matcher((nameAST = ast.findFirstToken(58)).getText()).find()) {
            this.log(nameAST.getLineNo(), nameAST.getColumnNo(), MSG_INVALID_PATTERN, nameAST.getText(), this.format.pattern());
        }
    }
}

