/*
UnnecessaryParentheses
tokens = (default)EXPR, IDENT, NUM_DOUBLE, NUM_FLOAT, NUM_INT, NUM_LONG, \
         STRING_LITERAL, LITERAL_NULL, LITERAL_FALSE, LITERAL_TRUE, ASSIGN, \
         BAND_ASSIGN, BOR_ASSIGN, BSR_ASSIGN, BXOR_ASSIGN, DIV_ASSIGN, \
         MINUS_ASSIGN, MOD_ASSIGN, PLUS_ASSIGN, SL_ASSIGN, SR_ASSIGN, STAR_ASSIGN, \
         LAMBDA, TEXT_BLOCK_LITERAL_BEGIN, LAND, LITERAL_INSTANCEOF, GT, LT, GE, \
         LE, EQUAL, NOT_EQUAL, UNARY_MINUS, UNARY_PLUS, INC, DEC, LNOT, BNOT, \
         POST_INC, POST_DEC


*/

package com.puppycrawl.tools.checkstyle.checks.coding.unnecessaryparentheses;

public class InputUnnecessaryParenthesesIfStatement2 {

    void testShortCircuitOrIfStatement() {
        boolean a = false;
        boolean x = false, y = true, z = false;
        boolean v = true, w = true, u = true;
        boolean vy = x && y || (x || y || z) && v; // ok
        if (a && !(v && w || (x || y) && z || u && x)) { // ok
        }
        if (a && !(v && w || x || y && z || u && x)) { // ok
        }
        if (v ||
                (u || x || y)) { // violation
        }
        if ((v || x) == // ok
                (w || y)) {
        }
        if ((v || x) & // ok
                (w || y)) {
        }
        if (a && v || (w || z) && u || y) { // ok
        }
        if (a && x ||
                (y || z) // violation
                || vy && u) {
        }
    }

    public void checkBooleanStatements() {
        boolean a = true;
        int b = 42;
        int c = 42;
        int d = 32;
        if ((b == c) == a
                && (
                        ( // violation
                            (b==c)==(d>=b)==a!=(c==d))
                    || (b<=c)!=a==(c>=d))) {
            return;
        }

        if (( // violation
                a!=(b==c)
                        && (a // violation
                        && (b==c))) // violation
                || (a // violation
                || a!=(b<=c)) // ok
                || (a==(b!=d==(c==b) && a!=(b<=c)))) { // violation
                                                       // after '||'
            return;
        }

        if (a==(b>=c && a==(c==d && d!=b)) // ok
                && a==(c<=d)) { // ok
            return;
        }

        if (a && a==(b<=c)==(a
                && (b<=c))) { // violation
            return;
        }

        if (a==(b==c) // ok
                || a!=(b<=c)) { // ok
            return;
        }

        if ((b==0) == (c==d) // ok
                && (Integer.valueOf(d) instanceof Integer) == true) { // ok
            return;
        }
    }
}
