/*
 * Decompiled with CFR 0.152.
 */
package com.pushwoosh.firebase;

import android.content.Context;
import android.os.Bundle;
import com.google.firebase.messaging.RemoteMessage;
import com.pushwoosh.PushwooshMessagingServiceHelper;
import com.pushwoosh.firebase.a.b;
import com.pushwoosh.internal.specific.DeviceSpecificProvider;
import com.pushwoosh.internal.utils.PWLog;
import com.pushwoosh.repository.RepositoryModule;
import java.util.Map;

public class PushwooshFcmHelper {
    private static final String TAG = "PushwooshFcmHelper";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void onTokenRefresh(String string) {
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        PWLog.noise((String)TAG, (String)String.format("onTokenRefresh: %s", objectArray2));
        if (!PushwooshFcmHelper.isDeviceSpecificOk()) {
            PWLog.error((String)TAG, (String)"Device specific provider not ready for Firebase");
            return;
        }
        try {
            String string2 = RepositoryModule.getRegistrationPreferences().pushToken().get();
            if (string != null && !string.equals(string2)) {
                PushwooshMessagingServiceHelper.onTokenRefresh((String)string);
                return;
            }
            PWLog.debug((String)TAG, (String)"token is null or equals previous token");
            return;
        }
        catch (Exception exception) {
            PWLog.error((String)TAG, (String)"can't refresh token", (Throwable)exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean onMessageReceived(Context context, RemoteMessage remoteMessage) {
        Bundle bundle;
        PWLog.noise((String)TAG, (String)"onMessageReceived()");
        if (!PushwooshFcmHelper.isDeviceSpecificOk()) {
            PWLog.error((String)TAG, (String)"Device specific provider not ready for Firebase");
            return false;
        }
        if (!PushwooshFcmHelper.isPushwooshMessage(remoteMessage)) {
            PWLog.warn((String)TAG, (String)"skip onMessageReceived: message is not belongs to Pushwoosh");
            return false;
        }
        RemoteMessage remoteMessage2 = remoteMessage;
        String string = TAG;
        String string2 = "Received message: %s from: %s";
        Object[] objectArray = new Object[2];
        int n = 0;
        objectArray[n] = remoteMessage.getData();
        n = 1;
        objectArray[n] = remoteMessage.getFrom();
        PWLog.info((String)string, (String)String.format(string2, objectArray));
        Object object = remoteMessage2.getData();
        Bundle bundle2 = bundle;
        bundle = new Bundle();
        if (object == null) return PushwooshMessagingServiceHelper.onMessageReceived((Context)context, (Bundle)bundle2);
        try {
            object = object.entrySet().iterator();
        }
        catch (Exception exception) {
            PWLog.error((String)TAG, (String)"can't handle onMessageReceived", (Throwable)exception);
            return false;
        }
        while (true) {
            if (!object.hasNext()) return PushwooshMessagingServiceHelper.onMessageReceived((Context)context, (Bundle)bundle2);
            break;
        }
        {
            Bundle bundle3 = bundle2;
            Map.Entry entry = (Map.Entry)object.next();
            bundle3.putString((String)entry.getKey(), (String)entry.getValue());
            continue;
        }
    }

    private static boolean ensureDeviceSpecificProviderInitialized() {
        block4: {
            try {
                if (DeviceSpecificProvider.getInstance() != null) break block4;
            }
            catch (Exception exception) {
                PWLog.error((String)TAG, (String)"can't initialize DeviceSpecificProvider", (Throwable)exception);
                return false;
            }
            new DeviceSpecificProvider.Builder().setDeviceSpecific(b.a()).build(true);
            return DeviceSpecificProvider.getInstance() != null;
        }
        return true;
    }

    private static boolean isDeviceSpecificOk() {
        if (!PushwooshFcmHelper.ensureDeviceSpecificProviderInitialized()) {
            PWLog.error((String)TAG, (String)"DeviceSpecificProvider not initialized");
            return false;
        }
        if (!DeviceSpecificProvider.getInstance().isFirebase()) {
            PWLog.error((String)TAG, (String)"Device specific is not Firebase");
            return false;
        }
        return true;
    }

    public static boolean isPushwooshMessage(RemoteMessage object) {
        boolean bl = (object = object.getData()) != null && object.containsKey("pw_msg");
        return bl;
    }

    public static Bundle messageToBundle(RemoteMessage object) {
        Bundle bundle;
        object = object.getData();
        Bundle bundle2 = bundle;
        bundle = new Bundle();
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                bundle2.putString((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return bundle2;
    }
}

