/*
 * Decompiled with CFR 0.152.
 */
package com.pushwoosh.firebase;

import android.content.Context;
import android.os.Bundle;
import com.google.firebase.messaging.RemoteMessage;
import com.pushwoosh.PushwooshMessagingServiceHelper;
import com.pushwoosh.firebase.b.a;
import com.pushwoosh.internal.specific.DeviceSpecific;
import com.pushwoosh.internal.specific.DeviceSpecificProvider;
import com.pushwoosh.internal.utils.PWLog;
import com.pushwoosh.repository.RepositoryModule;
import java.util.Map;

public class PushwooshFcmHelper {
    private static final String TAG = "PushwooshFcmHelper";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void onTokenRefresh(String string) {
        Exception exception2;
        block4: {
            StringBuilder stringBuilder = new StringBuilder("onTokenRefresh: ");
            stringBuilder.append(string);
            PWLog.noise((String)TAG, (String)stringBuilder.toString());
            if (!PushwooshFcmHelper.isDeviceSpecificOk()) {
                PWLog.error((String)TAG, (String)"Device specific provider not ready for Firebase");
                return;
            }
            try {
                String string2 = RepositoryModule.getRegistrationPreferences().pushToken().get();
                if (string != null && !string.equals(string2)) {
                    PushwooshMessagingServiceHelper.onTokenRefresh((String)string);
                    return;
                }
            }
            catch (Exception exception2) {
                break block4;
            }
            PWLog.debug((String)TAG, (String)"token is null or equals previous token");
            return;
        }
        PWLog.error((String)TAG, (String)"can't refresh token", (Throwable)exception2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean onMessageReceived(Context context, RemoteMessage object) {
        Bundle bundle;
        PWLog.noise((String)TAG, (String)"onMessageReceived()");
        if (!PushwooshFcmHelper.isDeviceSpecificOk()) {
            PWLog.error((String)TAG, (String)"Device specific provider not ready for Firebase");
            return false;
        }
        if (!PushwooshFcmHelper.isPushwooshMessage((RemoteMessage)object)) {
            PWLog.warn((String)TAG, (String)"skip onMessageReceived: message is not belongs to Pushwoosh");
            return false;
        }
        Object object2 = object;
        String string = TAG;
        String string2 = "Received message: %s from: %s";
        Object object3 = object;
        Object object4 = object3;
        object = object3.getData();
        String string3 = object4.getFrom();
        PWLog.info((String)string, (String)String.format(string2, object, string3));
        object = object2.getData();
        string3 = bundle;
        bundle = new Bundle();
        if (object == null) return PushwooshMessagingServiceHelper.onMessageReceived((Context)context, (Bundle)string3);
        try {
            object = object.entrySet().iterator();
        }
        catch (Exception exception) {
            PWLog.error((String)TAG, (String)"can't handle onMessageReceived", (Throwable)exception);
            return false;
        }
        while (true) {
            if (!object.hasNext()) return PushwooshMessagingServiceHelper.onMessageReceived((Context)context, (Bundle)string3);
            break;
        }
        {
            String string4 = string3;
            Map.Entry entry = (Map.Entry)object.next();
            string4.putString((String)entry.getKey(), (String)entry.getValue());
            continue;
        }
    }

    private static boolean ensureDeviceSpecificProviderInitialized() {
        Exception exception2;
        block5: {
            block4: {
                try {
                    if (DeviceSpecificProvider.getInstance() != null) break block4;
                }
                catch (Exception exception2) {
                    break block5;
                }
                new DeviceSpecificProvider.Builder().setDeviceSpecific((DeviceSpecific)new a()).build(true);
                return DeviceSpecificProvider.getInstance() != null;
            }
            return true;
        }
        PWLog.error((String)TAG, (String)"can't initialize DeviceSpecificProvider", (Throwable)exception2);
        return false;
    }

    private static boolean isDeviceSpecificOk() {
        if (!PushwooshFcmHelper.ensureDeviceSpecificProviderInitialized()) {
            PWLog.error((String)TAG, (String)"DeviceSpecificProvider not initialized");
            return false;
        }
        if (!DeviceSpecificProvider.getInstance().isFirebase()) {
            PWLog.error((String)TAG, (String)"Device specific is not Firebase");
            return false;
        }
        return true;
    }

    public static boolean isPushwooshMessage(RemoteMessage object) {
        return (object = object.getData()) != null && object.containsKey("pw_msg");
    }

    public static Bundle messageToBundle(RemoteMessage object) {
        Bundle bundle;
        object = object.getData();
        Bundle bundle2 = bundle;
        bundle = new Bundle();
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                bundle2.putString((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return bundle2;
    }
}

