/*
 * Pyx4j framework
 * Copyright (C) 2006 pyx4.com.
 *
 * @author vlads
 * @version $Id: ExecuteJunction.java 1 2007-03-09 04:03:48Z vlads $
 */
package com.pyx4j.maven.plugin.junction;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoFailureException;

/**
 * Created on 19-Oct-06
 *
 */
public class ExecuteJunction {

	private String linkExe;

	private String unlinkExe;

	private String unlinkArg;

	private String linkArg;

	boolean needFixSubst = false;

	boolean isUnix = false;

	//J5 ExecuteJunction(List<Artifact> pluginArtifacts) throws MojoFailureException {
	ExecuteJunction(List pluginArtifacts) throws MojoFailureException {
		String myos = System.getProperty("os.name");
		if (myos == null) {
			throw new MojoFailureException("Unrecongized OS");
		}
		myos = myos.toLowerCase(Locale.ENGLISH);
		if (myos.startsWith("windows")) {
			if (myos.equals("windows 2000")) {
				needFixSubst = true;
			}
			File exec = null;
			//J5 for (Artifact a : pluginArtifacts) {
			for (Iterator i = pluginArtifacts.iterator(); i.hasNext();) {
				Artifact a = (Artifact) i.next();

				if ("junction".equals(a.getArtifactId())) {
					exec = a.getFile();
					break;
				}
			}
			if ((exec == null) || (!exec.canRead())) {
				throw new MojoFailureException("Can't find junction.exe in plugin dependency");
			}
			// Windows
			// usage: junction [-d] <junction directory> [<junction target>]
			// -d     Delete the specified junction
			linkExe = exec.getAbsolutePath();
			unlinkExe = linkExe;
			unlinkArg = "-d";
			isUnix = false;
		} else {
			// Unix
			// Usage: ln [OPTION]... TARGET LINK_NAME
			linkExe = "ln";
			linkArg = "-s";
			unlinkExe = "rm";
			isUnix = true;
		}
	}

	public String toString() {
		return linkExe;
	}

	boolean link(String dst, String src) {
		if (isUnix) {
			// Swap the order
			String tmp = dst;
			dst = src;
			src = tmp;
		}
		if (linkArg != null) {
			return run(linkExe, new String[] { linkArg, dst, src });
		} else {
			return run(linkExe, new String[] { dst, src });
		}
	}

	boolean unlink(String path) {
		if (unlinkArg != null) {
			return run(unlinkExe, new String[] { unlinkArg, path });
		} else {
			return run(unlinkExe, new String[] { path });
		}
	}

	private boolean run(String exe, String[] args) {
		String[] cmdarray = new String[args.length + 1];
		cmdarray[0] = exe;
		for (int i = 0; i < args.length; i++) {
			cmdarray[i + 1] = args[i];
		}
		try {
			Process proc = Runtime.getRuntime().exec(cmdarray, null, new File("."));
			try {
				int exitVal = proc.waitFor();
				if (exitVal == 0) {
					return true;
				} else {
					return false;
				}
			} catch (InterruptedException e) {
				return false;
			}
		} catch (IOException e) {
			throw new Error(e);
		}
	}

}
