/*
 * Pyx4j framework
 * Copyright (C) 2006 pyx4.com.
 * 
 * Created on 19-Oct-06
 * 
 * @author vlads
 * @version $Id: JunctionMojo.java 48 2007-03-19 19:33:47Z vlads $
 */
package com.pyx4j.maven.plugin.junction;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/**
 * Links the folders on windows on unix
 * Create Symlinks or junctions
 * 
 * @goal link
 *
 */
public class JunctionMojo extends BaseJunctionMojo {

    
    public void execute() throws MojoExecutionException, MojoFailureException {

        ExecuteJunction exe = new ExecuteJunction(pluginArtifacts);
        getLog().debug("junction exe " + exe);
                
        //J5 List<Link> runLinks = new Vector<Link>();
        List runLinks = new Vector();
        
        if (links != null) {
            runLinks.addAll(links);
        }
        
        if (composeClasses != null) {
        	if (!composeClasses.dst.exists()) {
        		if (composeClasses.dstCreate) {
        			try {
                        FileUtils.forceMkdir(composeClasses.dst);
                    } catch (IOException e) {
                        throw new MojoFailureException("Can't create src  [" + composeClasses.dst + "]");
                    }
        		} else {
        			throw new MojoFailureException("junction composeClasses dst [" + composeClasses.dst + "] does not exists");        			
        		}
        	}
            runLinks.addAll(composeClasses.getlinks());
        }
     
        //J5 for (Link link : runLinks) {
        for (Iterator i = runLinks.iterator(); i.hasNext();) {
        	Link link = (Link) i.next();
            getLog().debug("link " + link.getSrc() + " -> " + link.getDst());
            executeLink(link, exe);
        }
    }

    private void executeLink(Link link, ExecuteJunction exe) throws MojoFailureException {
        if (!link.getSrc().exists()) {
            if (link.isSrcCreate()) {
                try {
                    FileUtils.forceMkdir(link.getSrc());
                } catch (IOException e) {
                    throw new MojoFailureException("Can't create src  [" + link.getSrc().getParentFile() + "]");
                }
            } else if (link.isFailNoSrc()) {
                throw new MojoFailureException("junction source [" + link.getSrc() + "] does not exists");
            } else {
                return;
            }
        }
        
        if (link.getDst().exists()) {
            getLog().debug("removing link target first " + link.getDst());
            exe.unlink(link.getDst().getAbsolutePath());
            if (link.getDst().exists()) {
                if (!link.getDst().delete()) {
                    throw new MojoFailureException("Can't remove junction target [" + link.getDst() + "]");
                }
            }
        }
        if (!link.getDst().getParentFile().exists()) {
            try {
                FileUtils.forceMkdir(link.getDst().getParentFile());
            } catch (IOException e) {
                throw new MojoFailureException("Can't create target parent [" + link.getDst().getParentFile() + "]");
            }
        } else if (link.getDst().getParentFile().isFile()) {
            throw new MojoFailureException("File " + link.getDst().getParentFile() + " exists and is "
                    + "not a directory. Unable to create directory.");
        }

        exe.link(link.getDst().getAbsolutePath(), link.getSrc().getAbsolutePath());

        if (!link.getDst().exists()) {
            throw new MojoFailureException("Can't create junction source [" + link.getSrc() + "] -> [" + link.getDst()
                    + "]");
        }
    }

}
