/*
 * Pyx4j framework
 * Copyright (C) 2006 pyx4.com.
 *
 * Created on 19-Oct-06
 * 
 * @author vlads
 * @version $Id: JunctionUnlinkMojo.java 1 2007-03-09 04:03:48Z vlads $
 */
package com.pyx4j.maven.plugin.junction;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

/**
 * Unlinks the folder on windows on unix
 * 
 * @goal unlink
 * @phase clean
 */

public class JunctionUnlinkMojo extends BaseJunctionMojo {

    public void execute() throws MojoExecutionException, MojoFailureException {
       
        ExecuteJunction exe = new ExecuteJunction(pluginArtifacts);
        getLog().debug("junction exe " + exe);
        
        //J5 List<Link> runLinks = new Vector<Link>();
        List runLinks = new Vector();
        
        if (links != null) {
            runLinks.addAll(links);
        }
        
        if (composeClasses != null) {
            runLinks.addAll(composeClasses.getlinks());
        }
        
        //J5 for (Link link : runLinks) {
        for (Iterator i = runLinks.iterator(); i.hasNext();) {
        	Link link = (Link) i.next();
            getLog().debug("unlink " + link.getDst());
            if (link.getDst().exists()) {
                getLog().debug("removing link target " + link.getDst());
                exe.unlink(link.getDst().getAbsolutePath());
                if (link.getDst().exists()) {
                    if (!link.getDst().delete()) {
                        throw new MojoFailureException("Unable to delete directory: " + link.getDst());
                    }
                }
            }
        }

    }

}
