/*
 * Decompiled with CFR 0.152.
 */
package cldcunit.runner;

import java.io.PrintStream;
import java.util.Enumeration;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.StringItem;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class TestRunner
extends MIDlet
implements TestListener,
CommandListener {
    protected static TestRunner theInstance = null;
    protected Gauge aProgressBar;
    protected List aResultsList;
    protected PrintStream aWriter = System.out;
    protected StringItem aErrorInfo;
    protected StringItem aFailureInfo;
    protected TestResult aResult;
    protected boolean bScreenOutput = true;
    protected boolean bTextOutput = true;
    protected int nCount;
    private Command cmd_exit;

    public TestRunner() {
        if (theInstance != null) {
            throw new RuntimeException("Only one MIDlet instance allowed!");
        }
        theInstance = this;
    }

    public static TestRunner getInstance() {
        return theInstance;
    }

    public void setOutputMode(boolean bScreen, boolean bText) {
        this.bScreenOutput = bScreen;
        this.bTextOutput = bText;
    }

    public void setWriter(PrintStream aStream) {
        this.aWriter = aStream;
    }

    public PrintStream getWriter() {
        return this.aWriter;
    }

    public synchronized void addError(Test test, Throwable t) {
        System.out.print("E");
    }

    public synchronized void addFailure(Test test, AssertionFailedError e) {
        System.out.print("F");
    }

    public void addToResultsList(String sText) {
        if (this.bScreenOutput) {
            this.getResultsList().append(sText, null);
        }
        if (this.bTextOutput) {
            this.aWriter.println(sText);
        }
    }

    public void addToResultsList(Throwable t) {
        if (this.bScreenOutput) {
            String sMsg = t.getMessage() != null ? t.getMessage() : t.getClass().getName();
            this.getResultsList().append(sMsg, null);
        }
        if (this.bTextOutput) {
            t.printStackTrace();
        }
    }

    public void endTest(Test test) {
        if (this.aProgressBar != null) {
            this.aProgressBar.setValue(this.aProgressBar.getValue() + 1);
            this.aFailureInfo.setText(Integer.toString(this.aResult.failureCount()));
            this.aErrorInfo.setText(Integer.toString(this.aResult.errorCount()));
        }
    }

    public void endTestStep(Test test) {
        if (this.aProgressBar != null) {
            this.aProgressBar.setValue(this.aProgressBar.getValue() + 1);
        }
    }

    public synchronized void print(TestResult result) {
        this.printHeader(result);
        this.printErrors(result);
        this.printFailures(result);
        this.printFooter();
    }

    public void printErrors(TestResult result) {
        if (result.errorCount() != 0) {
            if (result.errorCount() == 1) {
                this.addToResultsList("There was " + result.errorCount() + " error:");
            } else {
                this.addToResultsList("There were " + result.errorCount() + " errors:");
            }
            int i = 1;
            Enumeration e = result.errors();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.addToResultsList(i + ") " + failure.failedTest());
                if (failure.thrownException() != null) {
                    this.addToResultsList(failure.thrownException());
                }
                ++i;
            }
        }
    }

    public void printFailures(TestResult result) {
        if (result.failureCount() != 0) {
            if (result.failureCount() == 1) {
                this.addToResultsList("There was " + result.failureCount() + " failure:");
            } else {
                this.addToResultsList("There were " + result.failureCount() + " failures:");
            }
            int i = 1;
            Enumeration e = result.failures();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.addToResultsList(i + ") " + failure.failedTest());
                if (failure.thrownException() != null) {
                    this.addToResultsList(failure.thrownException());
                }
                ++i;
            }
        }
    }

    public void printFooter() {
        this.addToResultsList("(c) CLDCUnit + J2MEUnit");
    }

    public void printHeader(TestResult result) {
        if (result.wasSuccessful()) {
            this.addToResultsList("OK");
            this.addToResultsList(" (" + result.runCount() + " tests)");
        } else {
            this.addToResultsList("FAILURES");
            this.addToResultsList("Test Results:");
            this.addToResultsList("Run: " + result.runCount());
            this.addToResultsList("Failures: " + result.failureCount());
            this.addToResultsList("Errors: " + result.errorCount());
        }
    }

    public void showResult() {
        if (this.bScreenOutput) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.getResultsList());
        }
    }

    public synchronized void startTest(Test test) {
        System.out.println();
        System.out.print(this.aResult.runCount() + " start (" + test.getClass().getName() + ")");
    }

    protected List getResultsList() {
        if (this.aResultsList == null) {
            this.aResultsList = new List("J2ME Unit", 3);
            this.aResultsList.addCommand(this.cmd_exit);
            this.aResultsList.setCommandListener((CommandListener)this);
        }
        return this.aResultsList;
    }

    protected Test createTestSuite(String[] rTestCaseClasses) {
        if (rTestCaseClasses.length < 1) {
            System.out.println("Usage: TestRunner testCaseName1 [... testCaseNameN]");
            System.exit(-1);
        }
        TestSuite aSuite = new TestSuite();
        for (int i = 0; i < rTestCaseClasses.length; ++i) {
            try {
                String sClass = rTestCaseClasses[i];
                Class<?> cClass = Class.forName(sClass);
                try {
                    TestCase test = (TestCase)cClass.newInstance();
                    Test suite = test.getHelper().getSuite();
                    if (suite != null) {
                        aSuite.addTest(test.getHelper().getSuite());
                        continue;
                    }
                    aSuite.addTest(new TestSuite(cClass));
                }
                catch (Exception e) {
                    aSuite.addTest(new TestSuite(cClass));
                }
                continue;
            }
            catch (Throwable e) {
                System.out.println("Access to TestCase " + rTestCaseClasses[i] + " failed: " + e.getMessage() + " - " + e.getClass().getName());
            }
        }
        return aSuite;
    }

    protected TestSuite createTestSuite(TestCase[] testCaseClasses) {
        TestSuite aSuite = new TestSuite();
        for (int i = 0; i < testCaseClasses.length; ++i) {
            try {
                TestCase test = testCaseClasses[i];
                try {
                    Test suite = test.getHelper().getSuite();
                    if (suite != null) {
                        aSuite.addTest(test.getHelper().getSuite());
                        continue;
                    }
                    aSuite.addTest(new TestSuite(test.getClass()));
                }
                catch (Exception e) {
                    aSuite.addTest(new TestSuite(test.getClass()));
                }
                continue;
            }
            catch (Throwable e) {
                System.out.println("Access to TestCase " + testCaseClasses[i] + " failed: " + e.getMessage() + " - " + e.getClass().getName());
            }
        }
        return aSuite;
    }

    protected void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.notifyDestroyed();
        theInstance = null;
    }

    protected void doRun(Test suite) {
        this.aResult = new TestResult();
        this.aResult.addListener(this);
        long startTime = System.currentTimeMillis();
        suite.run(this.aResult);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        this.addToResultsList("Time: " + runTime + "ms");
        this.print(this.aResult);
    }

    protected void pauseApp() {
    }

    protected void start(String[] rTestCaseClasses) {
        Test aTestSuite = this.createTestSuite(rTestCaseClasses);
        this.start(aTestSuite);
    }

    protected void start(TestCase[] testCaseClasses) {
        TestSuite aTestSuite = this.createTestSuite(testCaseClasses);
        this.start(aTestSuite);
    }

    private void start(final Test aTestSuite) {
        Display rDisplay = Display.getDisplay((MIDlet)this);
        Form aForm = new Form("TestRunner");
        this.nCount = aTestSuite.countTestCases();
        if (this.nCount == 0) {
            aForm.append("No tests found.");
            rDisplay.setCurrent((Displayable)aForm);
            return;
        }
        this.aProgressBar = new Gauge(null, false, this.nCount, 0);
        this.aFailureInfo = new StringItem("Failures:", "0");
        this.aErrorInfo = new StringItem("Errors:", "0");
        aForm.append("Testing...");
        aForm.append((Item)this.aProgressBar);
        aForm.append((Item)this.aFailureInfo);
        aForm.append((Item)this.aErrorInfo);
        this.cmd_exit = new Command("Exit", 7, 0);
        aForm.addCommand(this.cmd_exit);
        aForm.setCommandListener((CommandListener)this);
        rDisplay.setCurrent((Displayable)aForm);
        new Thread(){

            public void run() {
                try {
                    TestRunner.this.doRun(aTestSuite);
                    TestRunner.this.showResult();
                }
                catch (Exception e) {
                    System.out.println("Exception while running test: " + e);
                    e.printStackTrace();
                }
            }
        }.start();
    }

    protected void startApp() throws MIDletStateChangeException {
        try {
            String sTestClasses = this.getAppProperty("J2MEUnitTestClasses");
            System.out.println("Testing: " + sTestClasses);
            this.start(new String[]{sTestClasses});
        }
        catch (Exception e) {
            System.out.println("Exception while setting up tests: " + e);
            e.printStackTrace();
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.cmd_exit) {
            try {
                this.destroyApp(true);
            }
            catch (MIDletStateChangeException mIDletStateChangeException) {
                // empty catch block
            }
        }
    }
}

