/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import cldcunit.runner.InstrumentedTestCaseHelper;
import cldcunit.runner.TestCaseHelper;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestMethod;
import junit.framework.TestResult;

public abstract class TestCase
extends Assert
implements Test {
    private TestMethod ftestMethod;
    private TestMethod[] decleredTestMethods;
    private TestCaseHelper helper;

    public TestCase() {
        this.ftestMethod = null;
        this.helper = this.getHelper();
        this.decleredTestMethods = this.helper.createAllTestMethods();
    }

    public TestCase(String name) {
        TestMethod testMethod;
        this.helper = this.getHelper();
        this.ftestMethod = testMethod = this.helper.createTestMethod(name);
        this.decleredTestMethods = new TestMethod[]{testMethod};
    }

    public TestCase(TestMethod testMethod) {
        this.ftestMethod = testMethod;
    }

    public int countTestCases() {
        return 1;
    }

    protected TestResult createResult() {
        return new TestResult();
    }

    public TestResult run() {
        TestResult result = this.createResult();
        this.run(result);
        return result;
    }

    public void run(TestResult result) {
        result.run(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runBare() throws Throwable {
        this.setUp();
        try {
            this.runTest();
        }
        finally {
            this.tearDown();
        }
    }

    protected void runTest() throws Throwable {
        Assert.assertNotNull(this.ftestMethod);
        this.ftestMethod.run(this);
        System.out.println("." + this.ftestMethod);
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    public String toString() {
        return this.getTestMethod() + "(" + this.getClass().getName() + ")";
    }

    public TestMethod getTestMethod() {
        return this.ftestMethod;
    }

    public void setTestMethod(TestMethod testMethod) {
        this.ftestMethod = testMethod;
    }

    public String getName() {
        return this.getTestMethod().getName();
    }

    public void setName(String name) {
        this.ftestMethod = this.getHelper().createTestMethod(name);
    }

    public TestCaseHelper getHelper() {
        if (this.helper == null) {
            String javaVersion = System.getProperty("java.specification.version");
            try {
                this.helper = javaVersion != null && (javaVersion.equals("1.6") || javaVersion.equals("1.5") || javaVersion.equals("1.4")) ? (TestCaseHelper)Class.forName("cldcunit.runner.ReflectionTestCaseHelper").newInstance() : new InstrumentedTestCaseHelper();
                this.helper.setTestCase(this);
            }
            catch (Throwable e) {
                this.helper = new InstrumentedTestCaseHelper();
                this.helper.setTestCase(this);
            }
        }
        return this.helper;
    }

    public TestMethod[] getTestMethods() {
        return this.decleredTestMethods;
    }
}

