/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestMethod;
import junit.framework.TestResult;

public class TestSuite
implements Test {
    private Vector fTests = new Vector(10);
    private String fName;
    static /* synthetic */ Class class$junit$framework$TestCase;

    public TestSuite() {
    }

    public TestSuite(Class theClass, String name) {
        this(theClass);
        this.setName(name);
    }

    public TestSuite(Class theClass) {
        if ((class$junit$framework$TestCase == null ? (class$junit$framework$TestCase = TestSuite.class$("junit.framework.TestCase")) : class$junit$framework$TestCase).isAssignableFrom(theClass)) {
            this.fName = theClass.getName();
            try {
                TestCase test = (TestCase)theClass.newInstance();
                TestMethod[] methods = test.getTestMethods();
                if (methods != null) {
                    for (int i = 0; i < methods.length; ++i) {
                        this.addTestMethod(methods[i], theClass);
                    }
                }
                if (this.fTests.size() == 0) {
                    this.addTest(TestSuite.warning("No tests found in " + theClass.getName()));
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public TestSuite(String name) {
        this.setName(name);
    }

    public void addTest(Test test) {
        this.fTests.addElement(test);
    }

    public void addTestSuite(Class testClass) {
        this.addTest(new TestSuite(testClass));
    }

    private void addTestMethod(TestMethod m, Class theClass) {
        this.addTest(TestSuite.createTest(theClass, m));
    }

    public static Test createTest(Class theClass, TestMethod testMethod) {
        Test test = null;
        try {
            test = (Test)theClass.newInstance();
            if (test instanceof TestCase) {
                ((TestCase)test).setTestMethod(testMethod);
            }
        }
        catch (InstantiationException e) {
            return TestSuite.warning("Cannot instantiate test case: " + testMethod + " (" + TestSuite.exceptionToString(e) + ")");
        }
        catch (IllegalAccessException e) {
            return TestSuite.warning("Cannot access test case: " + testMethod + " (" + TestSuite.exceptionToString(e) + ")");
        }
        return test;
    }

    private static String exceptionToString(Throwable t) {
        return t.getMessage();
    }

    public int countTestCases() {
        int count = 0;
        Enumeration e = this.tests();
        while (e.hasMoreElements()) {
            Test test = (Test)e.nextElement();
            count += test.countTestCases();
        }
        return count;
    }

    public void run(TestResult result) {
        Enumeration e = this.tests();
        while (e.hasMoreElements() && !result.shouldStop()) {
            Test test = (Test)e.nextElement();
            this.runTest(test, result);
        }
    }

    public void runTest(Test test, TestResult result) {
        test.run(result);
    }

    public Test testAt(int index) {
        return (Test)this.fTests.elementAt(index);
    }

    public int testCount() {
        return this.fTests.size();
    }

    public Enumeration tests() {
        return this.fTests.elements();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    private static Test warning(final String message) {
        return new TestCase(new TestMethod("warning"){

            public void run(TestCase testCase) throws Throwable {
            }
        }){

            protected void runTest() {
                Assert.fail(message);
            }

            public TestMethod[] getTestMethods() {
                return null;
            }
        };
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

