/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.client;

import com.qaprosoft.zafira.client.ZafiraClient;
import com.qaprosoft.zafira.client.impl.ZafiraClientImpl;
import com.qaprosoft.zafira.listener.domain.ZafiraConfiguration;
import com.qaprosoft.zafira.models.dto.auth.AuthTokenType;
import com.qaprosoft.zafira.util.AsyncUtil;
import com.qaprosoft.zafira.util.ConfigurationUtil;
import com.qaprosoft.zafira.util.http.HttpClient;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;

public enum ZafiraSingleton {
    INSTANCE;

    private final CompletableFuture<HttpClient.Response<AuthTokenType>> INIT_FUTURE = CompletableFuture.supplyAsync(() -> {
        HttpClient.Response<AuthTokenType> result = null;
        try {
            CombinedConfiguration config = ConfigurationUtil.getConfiguration(false);
            boolean enabled = (Boolean)ZafiraConfiguration.ENABLED.get((Configuration)config);
            String url = (String)ZafiraConfiguration.SERVICE_URL.get((Configuration)config);
            String token = (String)ZafiraConfiguration.ACCESS_TOKEN.get((Configuration)config);
            this.zafiraClient = new ZafiraClientImpl(url);
            if (enabled && this.zafiraClient.isAvailable()) {
                result = this.zafiraClient.refreshToken(token);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return result;
    });
    private ZafiraClient zafiraClient;

    private ZafiraSingleton() {
        this.INIT_FUTURE.thenAccept(auth -> {
            if (auth != null && auth.getStatus() == 200) {
                this.zafiraClient.setAuthData((AuthTokenType)auth.getObject());
            }
        });
    }

    public ZafiraClient getClient() {
        return this.isRunning() ? this.zafiraClient : null;
    }

    public boolean isRunning() {
        HttpClient.Response<AuthTokenType> response;
        try {
            response = AsyncUtil.getAsync(this.INIT_FUTURE, "Cannot connect to zafira");
        }
        catch (Exception e) {
            return false;
        }
        return response != null && response.getStatus() == 200;
    }
}

