/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.client.impl;

import com.qaprosoft.zafira.client.BasicClient;
import com.qaprosoft.zafira.client.ExtendedClient;
import com.qaprosoft.zafira.config.CiConfig;
import com.qaprosoft.zafira.models.db.Initiator;
import com.qaprosoft.zafira.models.db.Status;
import com.qaprosoft.zafira.models.db.workitem.WorkItem;
import com.qaprosoft.zafira.models.dto.JobType;
import com.qaprosoft.zafira.models.dto.TagType;
import com.qaprosoft.zafira.models.dto.TestCaseType;
import com.qaprosoft.zafira.models.dto.TestRunType;
import com.qaprosoft.zafira.models.dto.TestSuiteType;
import com.qaprosoft.zafira.models.dto.TestType;
import com.qaprosoft.zafira.util.http.HttpClient;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedClientImpl
implements ExtendedClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedClientImpl.class);
    private final BasicClient client;

    public ExtendedClientImpl(BasicClient client) {
        this.client = client;
    }

    @Override
    public TestCaseType registerTestCase(Long suiteId, Long primaryOwnerId, Long secondaryOwnerId, String testClass, String testMethod) {
        TestCaseType testCase = new TestCaseType(testClass, testMethod, "", suiteId, primaryOwnerId, secondaryOwnerId);
        String testCaseDetails = String.format("testClass: %s, testMethod: %s, testSuiteId: %d, primaryOwnerId: %d, secondaryOwnerId: %d", testClass, testMethod, suiteId, primaryOwnerId, secondaryOwnerId);
        LOGGER.debug("Test Case details for registration:" + testCaseDetails);
        HttpClient.Response<TestCaseType> response = this.client.createTestCase(testCase);
        testCase = response.getObject();
        if (testCase == null) {
            throw new RuntimeException("Unable to register test case '" + String.format(testCaseDetails, testClass, testMethod, suiteId, primaryOwnerId) + "' for zafira service: " + this.client.getServiceUrl());
        }
        LOGGER.debug("Registered test case details:" + testCaseDetails);
        return testCase;
    }

    @Override
    public TestType registerWorkItems(Long testId, List<String> workItems) {
        TestType test = null;
        if (workItems != null && workItems.size() > 0) {
            HttpClient.Response<TestType> response = this.client.createTestWorkItems(testId, workItems);
            test = response.getObject();
        }
        return test;
    }

    @Override
    public WorkItem registerWorkItem(Long testId, WorkItem workItem) {
        WorkItem result = null;
        if (workItem != null) {
            HttpClient.Response<WorkItem> response = this.client.createOrUpdateTestWorkItem(testId, workItem);
            result = response.getObject();
        }
        return result;
    }

    @Override
    public TestSuiteType registerTestSuite(String suiteName, String fileName, Long userId) {
        TestSuiteType testSuite = new TestSuiteType(suiteName, fileName, userId);
        String testSuiteDetails = "suiteName: %s, fileName: %s, userId: %s";
        LOGGER.debug("Test Suite details for registration:" + String.format(testSuiteDetails, suiteName, fileName, userId));
        HttpClient.Response<TestSuiteType> response = this.client.createTestSuite(testSuite);
        testSuite = response.getObject();
        if (testSuite == null) {
            throw new RuntimeException("Unable to register test suite '" + suiteName + "' for zafira service: " + this.client.getServiceUrl());
        }
        LOGGER.debug("Registered test suite details:" + String.format(testSuiteDetails, testSuite.getName(), testSuite.getFileName(), testSuite.getUserId()));
        return testSuite;
    }

    @Override
    public JobType registerJob(String jobUrl, Long userId) {
        jobUrl = jobUrl.replaceAll("/$", "");
        String jobName = StringUtils.substringAfterLast((String)jobUrl, (String)"/");
        String jenkinsHost = "";
        if (jobUrl.contains("/view/")) {
            jenkinsHost = jobUrl.split("/view/")[0];
        } else if (jobUrl.contains("/job/")) {
            jenkinsHost = jobUrl.split("/job/")[0];
        }
        String jobDetails = "jobName: %s, jenkinsHost: %s, userId: %s";
        LOGGER.debug("Job details for registration:" + String.format(jobDetails, jobName, jenkinsHost, userId));
        JobType job = new JobType(jobName, jobUrl, jenkinsHost, userId);
        HttpClient.Response<JobType> response = this.client.createJob(job);
        job = response.getObject();
        if (job == null) {
            throw new RuntimeException("Unable to register job for zafira service: " + this.client.getServiceUrl());
        }
        LOGGER.debug("Registered job details:" + String.format(jobDetails, job.getName(), job.getJenkinsHost(), job.getUserId()));
        return job;
    }

    @Override
    public TestRunType registerTestRun(Long testSuiteId, Long userId, String configXML, Long jobId, Long parentJobId, CiConfig ciConfig, String workItem) {
        Initiator initiator = this.findInitiator(ciConfig.getCiBuildCause());
        TestRunType testRun = TestRunType.builder().ciRunId(ciConfig.getCiRunId()).testSuiteId(testSuiteId).userId(userId).scmURL(ciConfig.getGitUrl()).scmBranch(ciConfig.getGitBranch()).scmCommit(ciConfig.getGitCommit()).configXML(configXML).jobId(jobId).upstreamJobId(parentJobId).upstreamJobBuildNumber(ciConfig.getCiParentBuild()).buildNumber(ciConfig.getCiBuild()).startedBy(initiator).workItem(workItem).build();
        LOGGER.debug("Test Run details for registration:" + testRun.toString());
        HttpClient.Response<TestRunType> response = this.client.startTestRun(testRun);
        TestRunType registeredTestRun = response.getObject();
        if (registeredTestRun == null) {
            throw new RuntimeException("Unable to register test run '" + testRun.toString() + "' for zafira service: " + this.client.getServiceUrl());
        }
        LOGGER.debug("Registered test run details:" + registeredTestRun.toString());
        return registeredTestRun;
    }

    private Initiator findInitiator(CiConfig.BuildCase buildCase) {
        Initiator initiator;
        switch (buildCase) {
            case UPSTREAMTRIGGER: {
                initiator = Initiator.UPSTREAM_JOB;
                break;
            }
            case TIMERTRIGGER: 
            case SCMTRIGGER: {
                initiator = Initiator.SCHEDULER;
                break;
            }
            case MANUALTRIGGER: {
                initiator = Initiator.HUMAN;
                break;
            }
            default: {
                throw new RuntimeException("Unable to register test run for zafira service: " + this.client.getServiceUrl() + " due to the misses build cause: '" + (Object)((Object)buildCase) + "'");
            }
        }
        return initiator;
    }

    @Override
    public TestRunType registerTestRunByHUMAN(Long testSuiteId, Long userId, String configXML, Long jobId, CiConfig ciConfig, Initiator startedBy, String workItem) {
        TestRunType testRun = new TestRunType(ciConfig.getCiRunId(), testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), configXML, jobId, ciConfig.getCiBuild(), startedBy, workItem);
        String testRunDetails = "testSuiteId: %s, userId: %s, scmURL: %s, scmBranch: %s, scmCommit: %s, jobId: %s, buildNumber: %s, startedBy: %s, workItem";
        LOGGER.debug("Test Run details for registration:" + String.format(testRunDetails, new Object[]{testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem}));
        HttpClient.Response<TestRunType> response = this.client.startTestRun(testRun);
        testRun = response.getObject();
        if (testRun == null) {
            throw new RuntimeException("Unable to register test run '" + String.format(testRunDetails, new Object[]{testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem}) + "' for zafira service: " + this.client.getServiceUrl());
        }
        LOGGER.debug("Registered test run details:" + String.format(testRunDetails, new Object[]{testSuiteId, userId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem}));
        return testRun;
    }

    @Override
    public TestRunType registerTestRunBySCHEDULER(Long testSuiteId, String configXML, Long jobId, CiConfig ciConfig, Initiator startedBy, String workItem) {
        TestRunType testRun = new TestRunType(ciConfig.getCiRunId(), testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), configXML, jobId, ciConfig.getCiBuild(), startedBy, workItem);
        String testRunDetails = "testSuiteId: %s, scmURL: %s, scmBranch: %s, scmCommit: %s, jobId: %s, buildNumber: %s, startedBy: %s, workItem";
        LOGGER.debug("Test Run details for registration:" + String.format(testRunDetails, new Object[]{testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem}));
        HttpClient.Response<TestRunType> response = this.client.startTestRun(testRun);
        testRun = response.getObject();
        if (testRun == null) {
            throw new RuntimeException("Unable to register test run '" + String.format(testRunDetails, new Object[]{testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem}) + "' for zafira service: " + this.client.getServiceUrl());
        }
        LOGGER.debug("Registered test run details:" + String.format(testRunDetails, new Object[]{testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, ciConfig.getCiBuild(), startedBy, workItem}));
        return testRun;
    }

    @Override
    public TestRunType registerTestRunUPSTREAM_JOB(Long testSuiteId, String configXML, Long jobId, Long parentJobId, CiConfig ciConfig, Initiator startedBy, String workItem) {
        TestRunType testRun = new TestRunType(ciConfig.getCiRunId(), testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), configXML, jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem);
        String testRunDetails = "testSuiteId: %s, scmURL: %s, scmBranch: %s, scmCommit: %s, jobId: %s, parentJobId: %s, parentBuildNumber: %s, buildNumber: %s, startedBy: %s, workItem";
        LOGGER.debug("Test Run details for registration:" + String.format(testRunDetails, new Object[]{testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem}));
        HttpClient.Response<TestRunType> response = this.client.startTestRun(testRun);
        testRun = response.getObject();
        if (testRun == null) {
            throw new RuntimeException("Unable to register test run '" + String.format(testRunDetails, new Object[]{testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem}) + "' for zafira service: " + this.client.getServiceUrl());
        }
        LOGGER.debug("Registered test run details:" + String.format(testRunDetails, new Object[]{testSuiteId, ciConfig.getGitUrl(), ciConfig.getGitBranch(), ciConfig.getGitCommit(), jobId, parentJobId, ciConfig.getCiParentBuild(), ciConfig.getCiBuild(), startedBy, workItem}));
        return testRun;
    }

    @Override
    public TestRunType registerTestRunResults(TestRunType testRun) {
        this.client.updateTestRun(testRun);
        HttpClient.Response<TestRunType> response = this.client.finishTestRun(testRun.getId());
        return response.getObject();
    }

    @Override
    public TestType registerTestStart(String name, String group, Status status, String testArgs, Long testRunId, Long testCaseId, int retryCount, String configXML, String[] dependsOnMethods, String ciTestId, Set<TagType> tags) {
        HttpClient.Response<TestType> response;
        Long startTime = new Date().getTime();
        String testDetails = "name: %s, status: %s, testArgs: %s, testRunId: %s, testCaseId: %s, startTime: %s, retry: %d";
        TestType test = new TestType(name, status, testArgs, testRunId, testCaseId, startTime, null, retryCount, configXML);
        LOGGER.debug("Test details for startup registration:" + String.format(testDetails, new Object[]{name, status, testArgs, testRunId, testCaseId, startTime, retryCount}));
        test.setCiTestId(ciTestId);
        test.setTestGroup(group);
        if (tags != null) {
            test.setTags(tags);
        }
        if (dependsOnMethods != null) {
            StringBuilder sb = new StringBuilder();
            for (String method : dependsOnMethods) {
                sb.append(StringUtils.substringAfterLast((String)method, (String)".")).append(" ");
            }
            test.setDependsOnMethods(sb.toString());
        }
        if ((test = (response = this.client.startTest(test)).getObject()) == null) {
            throw new RuntimeException("Unable to register test '" + String.format(testDetails, new Object[]{name, status, testArgs, testRunId, testCaseId, startTime, retryCount}) + "' startup for zafira service: " + this.client.getServiceUrl());
        }
        LOGGER.debug("Registered test startup details:" + String.format(testDetails, new Object[]{name, status, testArgs, testRunId, testCaseId, startTime, retryCount}));
        return test;
    }

    @Override
    public TestType registerTestRestart(TestType test) {
        String testName = test.getName();
        HttpClient.Response<TestType> response = this.client.startTest(test);
        if ((test = response.getObject()) == null) {
            throw new RuntimeException("Unable to register test '" + testName + "' restart for zafira service: " + this.client.getServiceUrl());
        }
        LOGGER.debug("Registered test restart details:'" + testName + "'; startTime: " + new Date(test.getStartTime()));
        return test;
    }
}

