/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.config;

import org.apache.commons.lang3.StringUtils;

public class CiConfig {
    private String ciRunId;
    private String ciUrl;
    private Integer ciBuild;
    private BuildCase ciBuildCause;
    private String ciParentUrl;
    private Integer ciParentBuild;
    private String gitBranch;
    private String gitCommit;
    private String gitUrl;

    private CiConfig() {
    }

    private CiConfig(String ciRunId, String ciUrl, Integer ciBuild, BuildCase ciBuildCause, String ciParentUrl, Integer ciParentBuild, String gitBranch, String gitCommit, String gitUrl) {
        this.ciRunId = ciRunId;
        this.ciUrl = ciUrl;
        this.ciBuild = ciBuild;
        this.ciBuildCause = ciBuildCause;
        this.ciParentUrl = ciParentUrl;
        this.ciParentBuild = ciParentBuild;
        this.gitBranch = gitBranch;
        this.gitCommit = gitCommit;
        this.gitUrl = gitUrl;
    }

    public String getCiRunId() {
        return this.ciRunId;
    }

    public String getCiUrl() {
        return this.ciUrl;
    }

    public Integer getCiBuild() {
        return this.ciBuild;
    }

    public BuildCase getCiBuildCause() {
        return this.ciBuildCause;
    }

    public String getCiParentUrl() {
        return this.ciParentUrl;
    }

    public Integer getCiParentBuild() {
        return this.ciParentBuild;
    }

    public String getGitBranch() {
        return this.gitBranch;
    }

    public String getGitCommit() {
        return this.gitCommit;
    }

    public String getGitUrl() {
        return this.gitUrl;
    }

    public static class Builder {
        private String ciRunId;
        private String ciUrl;
        private Integer ciBuild;
        private BuildCase ciBuildCause;
        private String ciParentUrl;
        private Integer ciParentBuild;
        private String gitBranch;
        private String gitCommit;
        private String gitUrl;

        public Builder setCiRunId(String ciRunId) {
            this.ciRunId = ciRunId;
            return this;
        }

        public Builder setCiUrl(String ciUrl) {
            this.ciUrl = StringUtils.removeEnd((String)ciUrl, (String)"/");
            return this;
        }

        public Builder setCiBuild(String ciBuild) {
            this.ciBuild = StringUtils.isEmpty((CharSequence)ciBuild) ? 0 : Integer.valueOf(ciBuild);
            return this;
        }

        public Builder setCiBuildCause(String ciBuildCause) {
            if (ciBuildCause != null) {
                this.ciBuildCause = BuildCase.valueOf(ciBuildCause.toUpperCase().split(",")[0]);
            }
            return this;
        }

        public Builder setCiParentUrl(String ciParentUrl) {
            this.ciParentUrl = StringUtils.removeEnd((String)ciParentUrl, (String)"/");
            return this;
        }

        public Builder setCiParentBuild(String ciParentBuild) {
            this.ciParentBuild = StringUtils.isEmpty((CharSequence)ciParentBuild) ? 0 : Integer.valueOf(ciParentBuild);
            return this;
        }

        public Builder setGitBranch(String gitBranch) {
            this.gitBranch = gitBranch;
            return this;
        }

        public Builder setGitCommit(String gitCommit) {
            this.gitCommit = gitCommit;
            return this;
        }

        public Builder setGitUrl(String gitUrl) {
            this.gitUrl = gitUrl;
            return this;
        }

        public CiConfig build() {
            return new CiConfig(this.ciRunId, this.ciUrl, this.ciBuild, this.ciBuildCause, this.ciParentUrl, this.ciParentBuild, this.gitBranch, this.gitCommit, this.gitUrl);
        }
    }

    public static enum BuildCase {
        UPSTREAMTRIGGER,
        TIMERTRIGGER,
        MANUALTRIGGER,
        SCMTRIGGER;

    }
}

