/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.listener;

import com.qaprosoft.zafira.config.IConfigurator;
import com.qaprosoft.zafira.listener.adapter.MethodAdapter;
import com.qaprosoft.zafira.listener.adapter.SuiteAdapter;
import com.qaprosoft.zafira.listener.adapter.TestAnnotationAdapter;
import com.qaprosoft.zafira.listener.adapter.TestContextAdapter;
import com.qaprosoft.zafira.listener.adapter.TestResultAdapter;
import com.qaprosoft.zafira.models.dto.TestType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcludeTestsForRerun {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcludeTestsForRerun.class);
    private static final String DO_NOT_RUN_TEST_NAMES = "doNotRunTestNames";
    private static final String ENABLED = "enabled";

    public static void excludeTestsForRerun(TestContextAdapter adapter, List<TestType> testRunResults, IConfigurator configurator) {
        SuiteAdapter suiteAdapter = adapter.getSuiteAdapter();
        ArrayList<String> testNamesNoRerun = new ArrayList<String>();
        HashSet<String> classesToRerun = new HashSet<String>();
        for (TestType test : testRunResults) {
            if (!test.isNeedRerun()) {
                testNamesNoRerun.add(test.getName());
                continue;
            }
            classesToRerun.add(test.getTestClass());
        }
        String[] testNamesNoRerunArr = testNamesNoRerun.toArray(new String[0]);
        Object[] allDependentMethods = suiteAdapter.getSuiteDependsOnMethods();
        boolean isAnythingMarked = true;
        while (isAnythingMarked) {
            isAnythingMarked = false;
            for (MethodAdapter methodAdapter : suiteAdapter.getMethodAdapters()) {
                Annotation[] annotations = methodAdapter.getMethodAnnotations();
                boolean isTest = false;
                boolean shouldUpdateDataProvider = false;
                for (Annotation a : annotations) {
                    boolean testNeedRerun;
                    TestAnnotationAdapter testAnnotationAdapter = methodAdapter.getTestAnnotationAdapter();
                    Class<? extends Annotation> testAnnotationClass = testAnnotationAdapter.getTestAnnotationClass();
                    if (testAnnotationClass == null || !testAnnotationClass.isAssignableFrom(a.getClass())) continue;
                    isTest = true;
                    boolean useDataProvider = StringUtils.isEmpty((CharSequence)methodAdapter.getTestAnnotationAdapter().getDataProviderName());
                    if (!useDataProvider) {
                        boolean classNeedRerun = classesToRerun.contains(methodAdapter.getRealClassName());
                        if (!classNeedRerun && ExcludeTestsForRerun.isTestEnabled(testAnnotationAdapter)) {
                            allDependentMethods = ExcludeTestsForRerun.skipDependentMethods((String[])allDependentMethods, a, methodAdapter);
                            isAnythingMarked = true;
                            break;
                        }
                        shouldUpdateDataProvider = true;
                        break;
                    }
                    if (ArrayUtils.contains((Object[])allDependentMethods, (Object)(methodAdapter.getRealClassName() + "." + methodAdapter.getMethodName())) || (testNeedRerun = ExcludeTestsForRerun.isTestNeedRerun(adapter, methodAdapter, testNamesNoRerun, configurator)) || !ExcludeTestsForRerun.isTestEnabled(testAnnotationAdapter)) break;
                    ExcludeTestsForRerun.skipDependentMethods((String[])allDependentMethods, a, methodAdapter);
                    isAnythingMarked = true;
                    break;
                }
                if (!isTest || !shouldUpdateDataProvider) continue;
                for (Annotation a : annotations) {
                    ExcludeTestsForRerun.modifyAnnotationValue(a, methodAdapter, DO_NOT_RUN_TEST_NAMES, testNamesNoRerunArr);
                }
            }
        }
    }

    private static void modifyAnnotationValue(Annotation a, MethodAdapter methodAdapter, String fieldName, Object newValue) {
        Method[] aMethods;
        Class<?> c = a.getClass();
        for (Method m : aMethods = c.getDeclaredMethods()) {
            Map memberValues;
            Field f;
            if (!fieldName.equals(m.getName())) continue;
            LOGGER.info(String.format("'%s' annotation was found for method '%s'", m.getName(), methodAdapter.getMethodName()));
            InvocationHandler handler = Proxy.getInvocationHandler(a);
            try {
                f = handler.getClass().getDeclaredField("memberValues");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new IllegalStateException(e);
            }
            f.setAccessible(true);
            try {
                memberValues = (Map)f.get(handler);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new IllegalStateException(e);
            }
            memberValues.put(fieldName, newValue);
            return;
        }
    }

    private static String[] skipDependentMethods(String[] allDependentMethods, Annotation methodAnnotation, MethodAdapter adapter) {
        ExcludeTestsForRerun.modifyAnnotationValue(methodAnnotation, adapter, ENABLED, false);
        return ExcludeTestsForRerun.removeDependentMethodsFromArray(allDependentMethods, adapter);
    }

    private static boolean isTestEnabled(TestAnnotationAdapter testAnnotationAdapter) {
        return testAnnotationAdapter.isEnabled();
    }

    private static String[] removeDependentMethodsFromArray(String[] allDependentMethods, MethodAdapter adapter) {
        for (String m : adapter.getMethodDependsOnMethods()) {
            allDependentMethods = (String[])ArrayUtils.removeElement((Object[])allDependentMethods, (Object)m);
        }
        return allDependentMethods;
    }

    private static boolean isTestNeedRerun(TestContextAdapter testContextAdapter, MethodAdapter methodAdapter, List<String> testNamesNoRerun, IConfigurator configurator) {
        TestResultAdapter testResultAdapter = testContextAdapter.getTestResultAdapter(methodAdapter);
        String testName = configurator.getTestName(testResultAdapter);
        return !testNamesNoRerun.contains(testName);
    }
}

