/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.listener;

import com.qaprosoft.zafira.client.ZafiraClient;
import com.qaprosoft.zafira.client.ZafiraSingleton;
import com.qaprosoft.zafira.config.CiConfig;
import com.qaprosoft.zafira.config.IConfigurator;
import com.qaprosoft.zafira.listener.ExcludeTestsForRerun;
import com.qaprosoft.zafira.listener.TestHookable;
import com.qaprosoft.zafira.listener.TestLifecycleAware;
import com.qaprosoft.zafira.listener.adapter.MethodAdapter;
import com.qaprosoft.zafira.listener.adapter.SuiteAdapter;
import com.qaprosoft.zafira.listener.adapter.TestContextAdapter;
import com.qaprosoft.zafira.listener.adapter.TestResultAdapter;
import com.qaprosoft.zafira.listener.adapter.TestResultStatus;
import com.qaprosoft.zafira.listener.domain.CiConfiguration;
import com.qaprosoft.zafira.listener.domain.ZafiraConfiguration;
import com.qaprosoft.zafira.listener.service.JobTypeService;
import com.qaprosoft.zafira.listener.service.ProjectTypeService;
import com.qaprosoft.zafira.listener.service.TestCaseTypeService;
import com.qaprosoft.zafira.listener.service.TestRunTypeService;
import com.qaprosoft.zafira.listener.service.TestSuiteTypeService;
import com.qaprosoft.zafira.listener.service.TestTypeService;
import com.qaprosoft.zafira.listener.service.UserTypeService;
import com.qaprosoft.zafira.listener.service.impl.JobTypeServiceImpl;
import com.qaprosoft.zafira.listener.service.impl.ProjectTypeServiceImpl;
import com.qaprosoft.zafira.listener.service.impl.TestCaseTypeServiceImpl;
import com.qaprosoft.zafira.listener.service.impl.TestRunTypeServiceImpl;
import com.qaprosoft.zafira.listener.service.impl.TestSuiteTypeServiceImpl;
import com.qaprosoft.zafira.listener.service.impl.TestTypeServiceImpl;
import com.qaprosoft.zafira.listener.service.impl.UserTypeServiceImpl;
import com.qaprosoft.zafira.models.db.Status;
import com.qaprosoft.zafira.models.db.workitem.BaseWorkItem;
import com.qaprosoft.zafira.models.db.workitem.WorkItem;
import com.qaprosoft.zafira.models.dto.JobType;
import com.qaprosoft.zafira.models.dto.TestArtifactType;
import com.qaprosoft.zafira.models.dto.TestCaseType;
import com.qaprosoft.zafira.models.dto.TestRunType;
import com.qaprosoft.zafira.models.dto.TestSuiteType;
import com.qaprosoft.zafira.models.dto.TestType;
import com.qaprosoft.zafira.models.dto.UserType;
import com.qaprosoft.zafira.models.dto.config.ConfigurationType;
import com.qaprosoft.zafira.util.ConfigurationUtil;
import com.qaprosoft.zafira.util.TestArtifactHolder;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZafiraEventRegistrar
implements TestLifecycleAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZafiraEventRegistrar.class);
    private static final String SKIP_CFG_EXC_MSG = "Skipping configuration method since test class doesn't contain test methods to rerun";
    private static final String INVALID_PROJECT_ERR_MSG = "Cannot register test run. You must specify project with name '%s' in your application.";
    private static final String ZAFIRA_RUN_ID_PARAM = "zafira_run_id";
    private static final String ALREADY_PASSED = "ALREADY_PASSED";
    private static final String ALREADY_FAILED_BY_KNOWN_BUG = "ALREADY_FAILED_BY_KNOWN_BUG";
    private boolean ZAFIRA_ENABLED;
    private String ZAFIRA_URL;
    private String ZAFIRA_PROJECT;
    private boolean ZAFIRA_RERUN_FAILURES;
    private String ZAFIRA_CONFIGURATOR;
    private String JIRA_SUITE_ID;
    private IConfigurator configurator;
    private CiConfig ci;
    private JobType parentJob;
    private TestSuiteType suite;
    private static TestRunType run;
    private final Map<String, TestType> registeredTests = new HashMap<String, TestType>();
    private final Set<String> classesToRerun = new HashSet<String>();
    private final Set<String> testsWithKnownIssues = new HashSet<String>();
    private static final ThreadLocal<String> threadCiTestId;
    private static final ThreadLocal<TestType> threadTest;
    private TestRunTypeService testRunTypeService;
    private TestSuiteTypeService testSuiteTypeService;
    private ProjectTypeService projectTypeService;
    private UserTypeService userTypeService;
    private JobTypeService jobTypeService;
    private TestTypeService testTypeService;
    private TestCaseTypeService testCaseTypeService;

    @Override
    public void onSuiteStart(SuiteAdapter adapter) {
        boolean initialized = this.initializeZafira(adapter);
        if (!initialized) {
            return;
        }
        try {
            this.configurator = (IConfigurator)Class.forName(this.ZAFIRA_CONFIGURATOR).newInstance();
            String project = (String)ZafiraConfiguration.PROJECT.get(adapter);
            project = !StringUtils.isEmpty((CharSequence)project) ? project : this.ZAFIRA_PROJECT;
            String existingProject = this.projectTypeService.initProject(project);
            if (existingProject == null) {
                this.ZAFIRA_ENABLED = false;
                LOGGER.error(String.format(INVALID_PROJECT_ERR_MSG, project));
                return;
            }
            UserType user = this.userTypeService.getUserProfile();
            String owner = this.configurator.getOwner(adapter);
            UserType suiteOwner = this.userTypeService.getUserOrAnonymousIfNotFound(owner);
            this.suite = this.testSuiteTypeService.register(adapter.getSuiteName(), adapter.getSuiteFileName(), suiteOwner.getId());
            JobType job = this.jobTypeService.register(this.ci.getCiUrl(), suiteOwner.getId());
            if (CiConfig.BuildCase.UPSTREAMTRIGGER.equals((Object)this.ci.getCiBuildCause())) {
                UserType anonymous = this.userTypeService.getUserOrAnonymousIfNotFound("anonymous");
                this.parentJob = this.jobTypeService.register(this.ci.getCiParentUrl(), anonymous.getId());
            }
            if (!StringUtils.isEmpty((CharSequence)this.ci.getCiRunId())) {
                run = this.testRunTypeService.findTestRunByCiRunId(this.ci.getCiRunId());
            }
            if (run != null) {
                run = this.testRunTypeService.rerun(run, this.ci.getCiBuild(), this.suite.getId(), this.configurator.getConfiguration());
            } else {
                if (this.ZAFIRA_RERUN_FAILURES) {
                    LOGGER.error("Unable to find data in Zafira Reporting Service with CI_RUN_ID: '" + this.ci.getCiRunId() + "'.\nRerun failures featrure will be disabled!");
                    this.ZAFIRA_RERUN_FAILURES = false;
                }
                Long parentJobId = this.parentJob != null ? Long.valueOf(this.parentJob.getId()) : null;
                run = this.testRunTypeService.register(this.suite.getId(), user.getId(), job.getId(), parentJobId, this.configurator.getConfiguration(), this.ci, this.JIRA_SUITE_ID);
            }
            if (run == null) {
                throw new RuntimeException("Unable to register test run for zafira service: " + this.ZAFIRA_URL);
            }
            ConfigurationUtil.addSystemConfiguration(ZAFIRA_RUN_ID_PARAM, String.valueOf(run.getId()));
            Runtime.getRuntime().addShutdownHook(new TestRunShutdownHook(this.testRunTypeService, run));
        }
        catch (Throwable e) {
            this.ZAFIRA_ENABLED = false;
            LOGGER.error("Undefined error during test run registration!", e);
        }
    }

    @Override
    public void onSuiteFinish() {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        try {
            this.testRunTypeService.registerTestRunResults(run, this.configurator.getConfiguration());
        }
        catch (Throwable e) {
            LOGGER.error("Unable to finish test run correctly", e);
        }
    }

    @Override
    public void onRunStart(TestContextAdapter adapter) {
        if (run != null) {
            List<TestType> testRunResults = this.testRunTypeService.findTestRunResults(run.getId());
            for (TestType test : testRunResults) {
                this.registeredTests.put(test.getName(), test);
                if (!test.isNeedRerun()) continue;
                this.classesToRerun.add(test.getTestClass());
            }
            if (this.ZAFIRA_RERUN_FAILURES) {
                ExcludeTestsForRerun.excludeTestsForRerun(adapter, testRunResults, this.configurator);
            }
        }
    }

    @Override
    public void onTestStart(TestResultAdapter adapter) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        try {
            TestType startedTest = null;
            String testName = this.configurator.getTestName(adapter);
            TestCaseType testCase = this.registerTestCase(adapter);
            if (this.testsWithKnownIssues.contains(testName)) {
                throw adapter.getSkipExceptionInstance("ALREADY_FAILED_BY_KNOWN_BUG: " + testName);
            }
            if (this.registeredTests.containsKey(testName)) {
                startedTest = this.registeredTests.get(testName);
                if (this.ZAFIRA_RERUN_FAILURES && !startedTest.isNeedRerun()) {
                    throw adapter.getSkipExceptionInstance("ALREADY_PASSED: " + testName);
                }
                startedTest.setTestCaseId(testCase.getId());
                startedTest.setFinishTime(null);
                startedTest.setStartTime(new Date().getTime());
                startedTest.setCiTestId(ZafiraEventRegistrar.getThreadCiTestId());
                startedTest.setTags(this.configurator.getTestTags(adapter));
                startedTest = this.testTypeService.registerTestRestart(startedTest);
            }
            if (startedTest == null) {
                String testArgs = Arrays.toString(adapter.getParameters());
                String group = null;
                String fullClassName = adapter.getMethodAdapter().getTestClassName();
                if (fullClassName.contains(".")) {
                    group = fullClassName.substring(0, fullClassName.lastIndexOf("."));
                }
                String[] dependsOnMethods = adapter.getMethodAdapter().getMethodDependsOnMethods();
                startedTest = this.testTypeService.registerTestStart(testName, group, Status.IN_PROGRESS, testArgs, run.getId(), testCase.getId(), this.configurator.getRunCount(adapter), this.convertToXML(this.configurator.getConfiguration()), dependsOnMethods, ZafiraEventRegistrar.getThreadCiTestId(), this.configurator.getTestTags(adapter));
            }
            this.testTypeService.registerWorkItems(startedTest.getId(), this.configurator.getTestWorkItems(adapter));
            threadTest.set(startedTest);
            this.registeredTests.put(testName, startedTest);
            adapter.setAttribute("ztid", startedTest.getId());
        }
        catch (Throwable e) {
            if (adapter.getSkipExceptionInstance(null).getClass().isAssignableFrom(e.getClass())) {
                throw e;
            }
            LOGGER.error("Undefined error during test case/method start!", e);
        }
    }

    @Override
    public void onTestSuccess(TestResultAdapter adapter) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        try {
            this.finishTest(adapter, Status.PASSED);
        }
        catch (Throwable e) {
            LOGGER.error("Undefined error during test case/method finish!", e);
        }
    }

    @Override
    public void onTestFailure(TestResultAdapter adapter) {
        this.processResultOnTestFailure(adapter);
    }

    @Override
    public void onTestSkipped(TestResultAdapter adapter) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        if (adapter.getThrowable() != null && adapter.getThrowable().getMessage() != null && adapter.getThrowable().getMessage().startsWith(ALREADY_PASSED)) {
            return;
        }
        if (adapter.getThrowable() != null && adapter.getThrowable().getMessage() != null && adapter.getThrowable().getMessage().startsWith(ALREADY_FAILED_BY_KNOWN_BUG)) {
            return;
        }
        try {
            TestType test = threadTest.get();
            String testName = this.configurator.getTestName(adapter);
            if (test == null) {
                test = this.registeredTests.get(testName);
            }
            if (test == null) {
                TestCaseType testCase = this.registerTestCase(adapter);
                String testArgs = adapter.getParameters().toString();
                String group = adapter.getMethodAdapter().getTestClassName();
                group = group.substring(0, group.lastIndexOf("."));
                String[] dependsOnMethods = adapter.getMethodAdapter().getMethodDependsOnMethods();
                test = this.testTypeService.registerTestStart(testName, group, Status.SKIPPED, testArgs, run.getId(), testCase.getId(), this.configurator.getRunCount(adapter), this.convertToXML(this.configurator.getConfiguration()), dependsOnMethods, ZafiraEventRegistrar.getThreadCiTestId(), this.configurator.getTestTags(adapter));
                threadTest.set(test);
            }
            this.finishTest(adapter, Status.SKIPPED);
        }
        catch (Throwable e) {
            LOGGER.error("Undefined error during test case/method finish!", e);
        }
    }

    @Override
    public void onTestHook(TestHookable hookCallBack, TestResultAdapter adapter) {
        if (!this.ZAFIRA_ENABLED) {
            LOGGER.info("IHookCallBack: zafira not connected so running the test body");
            hookCallBack.runTestMethod(adapter);
        } else {
            String testName = this.configurator.getTestName(adapter);
            TestType startedTest = this.registeredTests.get(testName);
            if (this.ZAFIRA_RERUN_FAILURES && startedTest != null && !startedTest.isNeedRerun()) {
                LOGGER.info("IHookCallBack: test will not be executed since it already passed in previous run");
            } else {
                LOGGER.debug("IHookCallBack: default execution of test body");
                hookCallBack.runTestMethod(adapter);
            }
        }
    }

    @Override
    public void beforeMethodInvocation(MethodAdapter invokedMethodAdapter, TestResultAdapter adapter) {
        if (this.ZAFIRA_RERUN_FAILURES) {
            String declaringClassName = invokedMethodAdapter.getDeclaredClassName();
            String testClassName = invokedMethodAdapter.getTestClassName();
            if (!this.classesToRerun.contains(testClassName) && declaringClassName.equals(testClassName)) {
                if (invokedMethodAdapter.isBeforeClassConfiguration() || invokedMethodAdapter.isAfterClassConfiguration()) {
                    LOGGER.info("SKIPPING CONFIGURATION METHOD: " + declaringClassName + " : " + invokedMethodAdapter.getMethodName() + " for class " + testClassName);
                    throw adapter.getSkipExceptionInstance(SKIP_CFG_EXC_MSG);
                }
                if (invokedMethodAdapter.isBeforeTestConfiguration() || invokedMethodAdapter.isAfterTestConfiguration()) {
                    boolean shouldSkip = true;
                    for (String className : adapter.getKnownClassNames()) {
                        if (!this.classesToRerun.contains(className)) continue;
                        shouldSkip = false;
                        break;
                    }
                    if (shouldSkip) {
                        LOGGER.info("SKIPPING CONFIGURATION METHOD: " + declaringClassName + " : " + invokedMethodAdapter.getMethodName() + " for class " + testClassName);
                        throw adapter.getSkipExceptionInstance(SKIP_CFG_EXC_MSG);
                    }
                }
            }
        }
    }

    private boolean initializeZafira(SuiteAdapter adapter) {
        try {
            CombinedConfiguration config = ConfigurationUtil.getConfiguration();
            this.ci = ConfigurationUtil.retrieveCiConfig(config);
            this.JIRA_SUITE_ID = (String)CiConfiguration.JIRA_SUITE_ID.get((Configuration)config, adapter);
            this.ZAFIRA_ENABLED = (Boolean)ZafiraConfiguration.ENABLED.get((Configuration)config, adapter);
            this.ZAFIRA_URL = (String)ZafiraConfiguration.SERVICE_URL.get((Configuration)config, adapter);
            this.ZAFIRA_PROJECT = (String)ZafiraConfiguration.PROJECT.get((Configuration)config, adapter);
            this.ZAFIRA_RERUN_FAILURES = (Boolean)ZafiraConfiguration.RERUN_FAILURES.get((Configuration)config, adapter);
            this.ZAFIRA_CONFIGURATOR = (String)ZafiraConfiguration.CONFIGURATOR.get((Configuration)config, adapter);
            if (this.ZAFIRA_ENABLED) {
                ZafiraClient zc = ZafiraSingleton.INSTANCE.getClient();
                if (zc != null) {
                    this.ZAFIRA_ENABLED = zc.isAvailable();
                    this.testRunTypeService = new TestRunTypeServiceImpl(zc);
                    this.testSuiteTypeService = new TestSuiteTypeServiceImpl(zc);
                    this.projectTypeService = new ProjectTypeServiceImpl(zc);
                    this.userTypeService = new UserTypeServiceImpl(zc);
                    this.jobTypeService = new JobTypeServiceImpl(zc);
                    this.testTypeService = new TestTypeServiceImpl(zc);
                    this.testCaseTypeService = new TestCaseTypeServiceImpl(zc);
                }
                LOGGER.info("Zafira is " + (this.ZAFIRA_ENABLED ? "available" : "unavailable"));
            }
        }
        catch (NoSuchElementException e) {
            LOGGER.error("Unable to find config property: ", (Throwable)e);
        }
        return this.ZAFIRA_ENABLED;
    }

    private String convertToXML(ConfigurationType config) {
        StringWriter w = new StringWriter();
        try {
            Marshaller marshaller = JAXBContext.newInstance((Class[])new Class[]{ConfigurationType.class}).createMarshaller();
            marshaller.marshal((Object)(config != null ? config : new ConfigurationType()), (Writer)w);
        }
        catch (Throwable thr) {
            LOGGER.error("Unable to convert config to XML!", thr);
        }
        return w.toString();
    }

    private String getFullStackTrace(TestResultAdapter adapter) {
        StringBuilder sb;
        block4: {
            block3: {
                sb = new StringBuilder();
                if (adapter.getThrowable() != null) break block3;
                if (adapter.getStatus().getCode() != TestResultStatus.SKIP.getCode()) break block4;
                String[] methods = adapter.getMethodAdapter().getMethodDependsOnMethods();
                String dependentMethodName = null;
                for (TestResultAdapter failedTestResultAdapter : adapter.getFailedTestResults()) {
                    String failedTestResultAdapterName = failedTestResultAdapter.getName();
                    dependentMethodName = this.getDependentMethodName(methods, failedTestResultAdapterName);
                }
                for (TestResultAdapter skippedTestResultAdapter : adapter.getSkippedTestResults()) {
                    String skippedTestResultAdapterName = skippedTestResultAdapter.getName();
                    String skippedDependentMethodName = this.getDependentMethodName(methods, skippedTestResultAdapterName);
                    dependentMethodName = skippedDependentMethodName != null ? skippedDependentMethodName : dependentMethodName;
                }
                if (dependentMethodName == null) break block4;
                sb.append("Test skipped due to the dependency from: ").append(dependentMethodName);
                break block4;
            }
            sb.append(adapter.getThrowable().getMessage()).append("\n");
            for (StackTraceElement elem : adapter.getThrowable().getStackTrace()) {
                sb.append("\n").append(elem.toString());
            }
        }
        return !StringUtils.isEmpty((CharSequence)sb.toString()) ? sb.toString() : null;
    }

    private String getDependentMethodName(String[] methods, String testName) {
        String result = null;
        boolean contains = Arrays.stream(methods).anyMatch(method -> method.contains(testName));
        if (contains) {
            result = testName;
        }
        return result;
    }

    public static String getThreadCiTestId() {
        if (StringUtils.isEmpty((CharSequence)threadCiTestId.get())) {
            threadCiTestId.set(UUID.randomUUID().toString());
        }
        return threadCiTestId.get();
    }

    private void processResultOnTestFailure(TestResultAdapter adapter) {
        if (!this.ZAFIRA_ENABLED) {
            return;
        }
        try {
            this.finishTest(adapter, Status.FAILED);
        }
        catch (Throwable e) {
            LOGGER.error("Undefined error during test case/method finish!", e);
        }
    }

    private TestType populateTestResult(TestResultAdapter adapter, Status status, String message) {
        long threadId = Thread.currentThread().getId();
        TestType test = threadTest.get();
        Long finishTime = new Date().getTime();
        String testName = this.configurator.getTestName(adapter);
        LOGGER.debug("testName registered with current thread is: " + testName);
        if (test == null) {
            throw new RuntimeException("Unable to find TestType result to mark test as finished! name: '" + testName + "'; threadId: " + threadId);
        }
        test.setTestMetrics(this.configurator.getTestMetrics(adapter));
        test.setConfigXML(this.convertToXML(this.configurator.getConfiguration()));
        Set<TestArtifactType> testArtifacts = TestArtifactHolder.getAndClear();
        test.setArtifacts(testArtifacts);
        test.setTags(this.configurator.getTestTags(adapter));
        String testDetails = "testId: %d; testCaseId: %d; testRunId: %d; name: %s; thread: %s; status: %s, finishTime: %s \n message: %s";
        String logMessage = String.format(testDetails, new Object[]{test.getId(), test.getTestCaseId(), test.getTestRunId(), test.getName(), threadId, status, finishTime, message});
        LOGGER.debug("Test details to finish registration:" + logMessage);
        test.setStatus(status);
        test.setMessage(message);
        test.setFinishTime(finishTime);
        threadTest.remove();
        threadCiTestId.remove();
        return test;
    }

    private void finishTest(TestResultAdapter adapter, Status status) {
        String fullStackTrace = this.getFullStackTrace(adapter);
        TestType finishedTest = this.populateTestResult(adapter, status, fullStackTrace);
        finishedTest = this.testTypeService.finishTest(finishedTest);
        if (Status.FAILED.equals((Object)status) || Status.SKIPPED.equals((Object)status)) {
            if (finishedTest.isKnownIssue()) {
                LOGGER.info(String.format("Test '%s' failed due to known issue", finishedTest.getName()));
                this.testsWithKnownIssues.add(finishedTest.getName());
            }
            this.registerKnownIssue(adapter, finishedTest.getId(), finishedTest.getTestCaseId());
        }
    }

    private void registerKnownIssue(TestResultAdapter adapter, Long testId, Long testCaseId) {
        BaseWorkItem knownIssue = this.configurator.getTestKnownIssue(adapter);
        if (knownIssue != null) {
            WorkItem workItem = new WorkItem(knownIssue.getJiraId(), knownIssue.getDescription(), testCaseId, WorkItem.Type.BUG);
            workItem.setBlocker(knownIssue.isBlocker());
            this.testTypeService.registerKnownIssue(testId, workItem);
        }
        this.configurator.clearTestWorkItemArtifacts();
    }

    private TestCaseType registerTestCase(TestResultAdapter adapter) {
        String po = this.configurator.getPrimaryOwner(adapter);
        String primaryOwnerName = !StringUtils.isEmpty((CharSequence)po) ? po : this.configurator.getOwner(adapter.getSuiteAdapter());
        UserType primaryOwner = this.userTypeService.getUserOrAnonymousIfNotFound(primaryOwnerName);
        LOGGER.debug("primaryOwner: " + primaryOwnerName);
        String secondaryOwnerName = this.configurator.getSecondaryOwner(adapter);
        UserType secondaryOwner = null;
        if (!StringUtils.isEmpty((CharSequence)secondaryOwnerName)) {
            secondaryOwner = this.userTypeService.getUserOrAnonymousIfNotFound(secondaryOwnerName);
            LOGGER.debug("secondaryOwner: " + secondaryOwnerName);
        }
        String testClass = adapter.getMethodAdapter().getTestClassName();
        String testMethod = this.configurator.getTestMethodName(adapter);
        Long testCaseSecondaryOwner = secondaryOwner != null ? Long.valueOf(secondaryOwner.getId()) : null;
        return this.testCaseTypeService.registerTestCase(this.suite.getId(), primaryOwner.getId(), testCaseSecondaryOwner, testClass, testMethod);
    }

    public static Optional<TestRunType> getTestRun() {
        return Optional.ofNullable(run);
    }

    public static Optional<TestType> getTest() {
        return Optional.ofNullable(threadTest.get());
    }

    static {
        threadCiTestId = new ThreadLocal();
        threadTest = new ThreadLocal();
    }

    public static class TestRunShutdownHook
    extends Thread {
        private final TestRunTypeService testRunTypeService;
        private final TestRunType testRun;

        TestRunShutdownHook(TestRunTypeService testRunTypeService, TestRunType testRun) {
            this.testRunTypeService = testRunTypeService;
            this.testRun = testRun;
        }

        @Override
        public void run() {
            if (this.testRun != null) {
                boolean aborted = this.testRunTypeService.abort(this.testRun.getId());
                LOGGER.info("TestRunShutdownHook was executed with result: " + aborted);
            }
        }
    }
}

