/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.listener.adapter.impl;

import com.qaprosoft.zafira.listener.adapter.MethodAdapter;
import com.qaprosoft.zafira.listener.adapter.TestAnnotationAdapter;
import com.qaprosoft.zafira.listener.adapter.impl.TestAnnotationAdapterImpl;
import java.lang.annotation.Annotation;
import org.testng.ITestNGMethod;
import org.testng.annotations.Test;

public class MethodAdapterImpl
implements MethodAdapter {
    private static final String ERR_MSG_METHOD_REQUIRED = "TestNG method is required to apply its data";
    private final ITestNGMethod method;

    public MethodAdapterImpl(ITestNGMethod method) {
        this.method = method;
    }

    @Override
    public Object getMethod() {
        this.methodNotNull();
        return this.method;
    }

    @Override
    public Annotation[] getMethodAnnotations() {
        this.methodNotNull();
        return this.method.getConstructorOrMethod().getMethod().getAnnotations();
    }

    @Override
    public String getMethodName() {
        this.methodNotNull();
        return this.method.getConstructorOrMethod().getMethod().getName();
    }

    @Override
    public String getDeclaredClassName() {
        this.methodNotNull();
        return this.method.getConstructorOrMethod().getDeclaringClass().getName();
    }

    @Override
    public String getTestClassName() {
        this.methodNotNull();
        return this.method.getTestClass().getName();
    }

    @Override
    public String getRealClassName() {
        this.methodNotNull();
        return this.method.getRealClass().getName();
    }

    @Override
    public String[] getMethodDependsOnMethods() {
        this.methodNotNull();
        return this.method.getMethodsDependedUpon();
    }

    @Override
    public boolean isBeforeClassConfiguration() {
        this.methodNotNull();
        return this.method.isBeforeClassConfiguration();
    }

    @Override
    public boolean isAfterClassConfiguration() {
        this.methodNotNull();
        return this.method.isAfterClassConfiguration();
    }

    @Override
    public boolean isBeforeTestConfiguration() {
        this.methodNotNull();
        return this.method.isBeforeTestConfiguration();
    }

    @Override
    public boolean isAfterTestConfiguration() {
        this.methodNotNull();
        return this.method.isAfterTestConfiguration();
    }

    @Override
    public TestAnnotationAdapter getTestAnnotationAdapter() {
        this.methodNotNull();
        Test testAnnotation = this.method.getConstructorOrMethod().getMethod().getAnnotation(Test.class);
        return new TestAnnotationAdapterImpl(testAnnotation);
    }

    private void methodNotNull() {
        if (this.method == null) {
            throw new RuntimeException(ERR_MSG_METHOD_REQUIRED);
        }
    }
}

