/*
 * Decompiled with CFR 0.152.
 */
package com.qaprosoft.zafira.listener.adapter.impl;

import com.qaprosoft.zafira.listener.adapter.MethodAdapter;
import com.qaprosoft.zafira.listener.adapter.SuiteAdapter;
import com.qaprosoft.zafira.listener.adapter.impl.MethodAdapterImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.testng.ISuite;
import org.testng.ITestNGMethod;

public class SuiteAdapterImpl
implements SuiteAdapter {
    private static final String ERR_MSG_SUITE_REQUIRED = "TestNG suite is required to apply its data";
    private final ISuite suite;

    public SuiteAdapterImpl(ISuite suite) {
        this.suite = suite;
    }

    @Override
    public Object getSuite() {
        this.suiteNotNull();
        return this.suite;
    }

    @Override
    public String getSuiteParameter(String name) {
        this.suiteNotNull();
        return this.suite.getParameter(name);
    }

    @Override
    public String getSuiteFileName() {
        this.suiteNotNull();
        return this.suite.getXmlSuite().getFileName();
    }

    @Override
    public String getSuiteName() {
        this.suiteNotNull();
        return this.suite.getName();
    }

    @Override
    public String[] getSuiteDependsOnMethods() {
        this.suiteNotNull();
        return this.suite.getAllMethods().stream().map(ITestNGMethod::getMethodsDependedUpon).reduce(ArrayUtils.EMPTY_STRING_ARRAY, ArrayUtils::addAll);
    }

    @Override
    public List<MethodAdapter> getMethodAdapters() {
        this.suiteNotNull();
        return this.suite.getAllMethods().stream().map(MethodAdapterImpl::new).collect(Collectors.toList());
    }

    private void suiteNotNull() {
        if (this.suite == null) {
            throw new RuntimeException(ERR_MSG_SUITE_REQUIRED);
        }
    }
}

